<?php

namespace Widget\Discount\CouponBundle\EventListener;

use JMS\DiExtraBundle\Annotation as DI;
use Widget\DiscountBundle\Model\DiscountCouponQuery;
use Widget\OrderBundle\Event\OrderFinishEvent;

/**
 * @DI\Service()
 */
class OrderFinishListener
{
    /**
     * @DI\Observe(OrderFinishEvent::EVENT_NAME)
     */
    public function delNotReUseCoupon(OrderFinishEvent $event)
    {
        $parameters = $event->getParameters();
        if (!isset($parameters['coupon_code']) || $parameters['coupon_code'] == "") {
            return;
        }

        $coupon = DiscountCouponQuery::create()
            ->filterByCouponCode($parameters['coupon_code'])
            ->filterByReUse(false)
            ->findOne();

        if ($coupon == null) {
            return;
        }

        $coupon->setCanUse(false)->save();
    }
}