<?php

namespace Widget\Discount\CouponBundle\EventListener;

use JMS\DiExtraBundle\Annotation as DI;
use Widget\Discount\CouponBundle\Discount\CouponDiscount;
use Widget\DiscountBundle\Event\DiscountFactoryEvent;
use Widget\DiscountBundle\Model\DiscountCouponQuery;

/**
 * @DI\Service()
 */
class CouponListener
{
    /**
     * @DI\Observe(DiscountFactoryEvent::EVENT_NAME)
     */
    public function factoryClass(DiscountFactoryEvent $event)
    {
        $moduleArray = $event->getModule();
        
        if (!isset($moduleArray['class_name']) || $moduleArray['class_name'] != 'CouponDiscount') {
            return;
        }

        $parameters = $event->getParameters();
        if (!isset($parameters['coupon_code']) || $parameters['coupon_code'] == "") {
            return;
        }

        $coupon = DiscountCouponQuery::create()
            ->filterById($moduleArray['id'])
            ->filterByCouponCode($parameters['coupon_code'])
            ->filterByCanUse(true)
            ->findOne();

        if ($coupon == null) {
            return;
        }

        $discountClass = CouponDiscount::create($moduleArray);
        $event->setObject($discountClass);
    }
}