<?php

namespace Widget\Discount\CouponBundle\Tests\EventListener;

use Backend\BaseBundle\Tests\Fixture\BaseWebTestCase;
use Widget\Discount\CouponBundle\EventListener\OrderFinishListener;
use Widget\DiscountBundle\Model\DiscountCouponQuery;
use Widget\OrderBundle\Event\OrderFinishEvent;
use Widget\OrderBundle\Model\Order;

class OrderFinishListenerTest extends BaseWebTestCase
{
    public function test_delNotReUseCoupon()
    {
        // arrange
        $orderFinishListener = $this->getMockBuilder(OrderFinishListener::class)
            ->disableOriginalConstructor()
            ->setMethods(null)
            ->getMock();
        $order = new Order();
        $con = $this->getMockBuilder(\PropelPDO::class)
            ->disableOriginalConstructor()
            ->setMethods(null)
            ->getMock();
        $parameters = array(
            'coupon_code' => 'useOnce'
        );
        $orderFinishEvent = new OrderFinishEvent($order, $con, $parameters);

        // act
        $orderFinishListener->delNotReUseCoupon($orderFinishEvent);

        // assert
        $discountCoupon = DiscountCouponQuery::create()->findOneByCouponCode('useOnce');
        $this->assertEquals(false, $discountCoupon->getCanUse());

        //
        $discountCoupon->setCanUse(true)->save();
    }

    public function test_delNotReUseCoupon_can_re_use()
    {
        // arrange
        $orderFinishListener = $this->getMockBuilder(OrderFinishListener::class)
            ->disableOriginalConstructor()
            ->setMethods(null)
            ->getMock();
        $order = new Order();
        $con = $this->getMockBuilder(\PropelPDO::class)
            ->disableOriginalConstructor()
            ->setMethods(null)
            ->getMock();
        $parameters = array(
            'coupon_code' => 'amount'
        );
        $orderFinishEvent = new OrderFinishEvent($order, $con, $parameters);

        // act
        $orderFinishListener->delNotReUseCoupon($orderFinishEvent);

        // assert
        $discountCoupon = DiscountCouponQuery::create()->findOneByCouponCode('amount');
        $this->assertEquals(true, $discountCoupon->getCanUse());

        
    }
}