<?php

namespace Widget\Discount\CouponBundle\Controller\Backend;

use Backend\BaseBundle\Controller\BaseController;
use Backend\BaseBundle\Model\Site;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Security;
use Widget\DiscountBundle\Model\DiscountModule;

/**
 * @Route("/discount/coupon")
 * @Security("has_role_or_superadmin('ROLE_DISCOUNT_COUPON_READ')") 設定權限
 */
class CouponController extends BaseController
{
    /**
     * @param Site $site
     * @return \ModelCriteria
     */
    protected function createQuery(Site $site)
    {
        // 手動加入 篩選條件
        $session = $this->get('session');
        $defaultFilterArray = array('filter' => array('ClassName' => 'CouponDiscount'));
        $filterArray = $session->get('backend_filter_Widget\Discount\CouponBundle\Controller\Backend\CouponController', array());
        $customFilterArray = $filterArray + $defaultFilterArray;
        $session->set('backend_filter_Widget\Discount\CouponBundle\Controller\Backend\CouponController', $customFilterArray);

        $query = $this->createBaseQuery($site);
        $this->buildSortQuery($query);
        $this->buildFilterQuery($query);
        return $query;
    }

    /**
     * 寫入時手動加入本 bundle 使用的折扣 Class 名稱
     */
    public function updateData($form)
    {
        /** @var DiscountModule $discountModule */
        $discountModule = $form->getData();
        if ($discountModule->isNew()) {
            $discountModule->setClassName('CouponDiscount');
        }
        // reuse 若空值 先改回 true
        if ($discountModule->getDiscountCoupon()) {
            $discountCoupon = $discountModule->getDiscountCoupon();
            if(!$discountCoupon->getReUse()) {
                $discountCoupon->setReUse(true);
            }
        }
        parent::updateData($form);
    }
}