<?php
namespace Widget\ContactusBundle\Tests\Controller\BackendAPI;

use Backend\BaseBundle\Model\SiteUserQuery;
use Backend\BaseBundle\Tests\Fixture\BackendWebTestCase;
use Widget\ContactusBundle\Model\Contactus;
use Widget\ContactusBundle\Model\ContactusQuery;

/**
 * Created by PhpStorm.
 * User: bubble
 * Date: 2016/11/24
 * Time: 下午 6:08
 */

class ContactusControllerTest extends BackendWebTestCase
{
    public function test_createAction_success()
    {
        //arrange
        $loginName = 'admin';
        $origin = 'http://localhost';
        $user = SiteUserQuery::create()->findOneByLoginName($loginName);
        $token = $this->createToken($user, $origin);

        $params = array(
            'username' => 'bubble_new',
            'email' => 'bubble_new@dgfactor.com',
            'phone' => '0912345678',
            'content' => '海綿寶寶與7個小矮人的故事。'
        );

        //act
        $this->client->request(
            'POST',
            $this->generateUrl('widget_contactus_backendapi_contactus_create', array()),
            array(),
            array(),
            array(
                'HTTP_ORIGIN' => $origin,
                'HTTP_AUTHORIZATION' => "Bearer $token",
            ),
            json_encode($params)
        );
        $response = $this->client->getResponse();
        $contactus = ContactusQuery::create()->findOneByUsername($params['username']);

        //assert
        $this->assertTrue($response->isOk());
        $this->assertEquals($params['email'], $contactus->getEmail());
        $this->assertEquals($params['phone'], $contactus->getPhone());
        $this->assertEquals($params['content'], $contactus->getContent());

        //reset
        $contactus->delete();
    }

    public function test_searchAction()
    {
        //arrange
        $loginName = 'admin';
        $origin = 'http://localhost';
        $token = $this->createToken(SiteUserQuery::create()->findOneByLoginName($loginName), $origin);
        $params = array(
            'page' => 1,
            'sort' => array(
                'username' => 'asc'
            ),
            'search' => array(
                'username' => '%bubble%',
            ),
        );

        //act
        $this->client->request(
            'GET',
            $this->generateUrl('widget_contactus_backendapi_contactus_search', $params),
            array(),
            array(),
            array(
                'HTTP_ORIGIN' => $origin,
                'HTTP_AUTHORIZATION' => "Bearer $token",
            )
        );
        $response = $this->client->getResponse();
        $result = json_decode($response->getContent(), true);

        //assert
        $this->assertTrue($response->isOk());
        $this->assertEquals(1, $result['pager']['page']);
        $this->assertEquals(1, $result['pager']['pages']);
        $this->assertEquals(1, $result['pager']['rows']);
        $this->assertEquals(1, count($result['data']));
        $this->assertEquals(array(
            'id',
            'username',
            'email',
            'phone',
            'created_at',
            'updated_at',
        ), array_keys($result['data'][0]));
    }

    public function test_readAction()
    {
        //arrange
        $loginName = 'admin';
        $origin = 'http://localhost';
        $user = SiteUserQuery::create()->findOneByLoginName($loginName);
        $token = $this->createToken($user, $origin);

        $contactus = ContactusQuery::create()->findOne();

        //act
        $this->client->request(
            'GET',
            $this->generateUrl('widget_contactus_backendapi_contactus_read', array('id'=>$contactus->getId())),
            array(),
            array(),
            array(
                'HTTP_ORIGIN' => $origin,
                'HTTP_AUTHORIZATION' => "Bearer $token",
            )
        );
        $response = $this->client->getResponse();

        //assert
        $this->assertTrue($response->isOk());

        //reset
    }

    public function test_deleteAction()
    {
        //arrange
        $loginName = 'admin';
        $origin = 'http://localhost';
        $user = SiteUserQuery::create()->findOneByLoginName($loginName);
        $token = $this->createToken($user, $origin);

        $contactus = ContactusQuery::create()->findOneByUsername('bubble');

        //act
        $this->client->request(
            'DELETE',
            $this->generateUrl('widget_contactus_backendapi_contactus_delete', array('id'=>$contactus->getId())),
            array(),
            array(),
            array(
                'HTTP_ORIGIN' => $origin,
                'HTTP_AUTHORIZATION' => "Bearer $token",
            )
        );

        $response = $this->client->getResponse();

        //assert
        $this->assertTrue($response->isOk());
        $this->assertNull(ContactusQuery::create()->findOneByUsername('bubble'));

        //reset

        $data = $contactus->toArray();
        $contactus = new Contactus();
        $contactus->fromArray($data);
        $contactus->save();
    }
}