<?php
namespace Widget\ContactusBundle\Tests\Controller\API;
use Backend\BaseBundle\Tests\Fixture\BaseWebTestCase;
use Symfony\Component\HttpFoundation\Response;
use Widget\ContactusBundle\Model\ContactusPeer;
use Widget\ContactusBundle\Model\ContactusQuery;


/**
 * Created by PhpStorm.
 * User: bubble
 * Date: 2016/3/22
 * Time: 下午 3:11
 * @group functional
 */
class ContactusControllerTest extends BaseWebTestCase
{

    private $messageId;

    public function setUp()
    {
        parent::setUp(); // TODO: Change the autogenerated stub
        $this->messageId = null;
    }

    protected function tearDown()
    {
        if($this->messageId){
            $contactus = ContactusQuery::create()->findPk($this->messageId);
            $contactus->delete();
        }
        parent::tearDown(); // TODO: Change the autogenerated stub
    }

    public function test_createAction_empty_data()
    {
        //arrange
        $data = array();

        //act
        $this->client->request(
            'POST',
            $this->generateUrl('widget_contactus_api_contactus_create'),
            array(),
            array(),
            array(),
            json_encode($data)
        );
        $result = $this->client->getResponse();

        //assert
        $this->assertEquals(Response::HTTP_BAD_REQUEST, $result->getStatusCode());
    }

    public function test_createAction_valid_data()
    {
        //arrange
        $data = array(
            'username' => 'bubble',
            'email' => 'bubble@dgfactor.com',
            'phone' => '12853714',
            'content' => '有BUG哦~',
        );

        //act
        $this->client->request(
            'POST',
            $this->generateUrl('widget_contactus_api_contactus_create'),
            array(),
            array(),
            array(),
            json_encode($data)
        );
        $result = $this->client->getResponse();

        //assert
        $this->assertTrue($result->isOk());
        $this->messageId = json_decode($result->getContent(), true)['id'];
        $this->assertNotEmpty($this->messageId);

    }

    public function test_createAction_empty_username()
    {
        //arrange
        $data = array(
            'username' => '',
            'email' => 'bubble@dgfactor.com',
            'phone' => '12853714',
            'content' => '有BUG哦~',
        );

        //act
        $this->client->request(
            'POST',
            $this->generateUrl('widget_contactus_api_contactus_create'),
            array(),
            array(),
            array(),
            json_encode($data)
        );
        $result = $this->client->getResponse();

        //assert
        $this->assertEquals(Response::HTTP_BAD_REQUEST, $result->getStatusCode());
    }

    public function test_createAction_empty_email()
    {
        //arrange
        $data = array(
            'username' => 'bubble',
            'email' => '',
            'phone' => '12853714',
            'content' => '有BUG哦~',
        );

        //act
        $this->client->request(
            'POST',
            $this->generateUrl('widget_contactus_api_contactus_create'),
            array(),
            array(),
            array(),
            json_encode($data)
        );
        $result = $this->client->getResponse();

        //assert
        $this->assertEquals(Response::HTTP_BAD_REQUEST, $result->getStatusCode());
    }


    public function test_createAction_bad_email()
    {
        //arrange
        $data = array(
            'username' => 'bubble',
            'email' => 'sdhfkklsdhfklj',
            'phone' => '12853714',
            'content' => '有BUG哦~',
        );

        //act
        $this->client->request(
            'POST',
            $this->generateUrl('widget_contactus_api_contactus_create'),
            array(),
            array(),
            array(),
            json_encode($data)
        );
        $result = $this->client->getResponse();

        //assert
        $this->assertEquals(Response::HTTP_BAD_REQUEST, $result->getStatusCode());
    }

    public function test_createAction_empty_phone()
    {
        //arrange
        $data = array(
            'username' => 'bubble',
            'email' => 'bubble@dgfactor.com',
            'phone' => '',
            'content' => '有BUG哦~',
        );

        //act
        $this->client->request(
            'POST',
            $this->generateUrl('widget_contactus_api_contactus_create'),
            array(),
            array(),
            array(),
            json_encode($data)
        );
        $result = $this->client->getResponse();

        //assert
        $this->assertEquals(Response::HTTP_BAD_REQUEST, $result->getStatusCode());
    }

    public function test_createAction_empty_content()
    {
        //arrange
        $data = array(
            'username' => 'bubble',
            'email' => 'bubble@dgfactor.com',
            'phone' => '12853714',
            'content' => '',
        );

        //act
        $this->client->request(
            'POST',
            $this->generateUrl('widget_contactus_api_contactus_create'),
            array(),
            array(),
            array(),
            json_encode($data)
        );
        $result = $this->client->getResponse();

        //assert
        $this->assertEquals(Response::HTTP_BAD_REQUEST, $result->getStatusCode());
    }
}