module.exports =
{
  "list": {
    "id": {
      "label": "#",
      "type": "id",
      "sort": true
    },
    "username": {
      "label": "index.contactus.username",
      "type": "text",
      "sort": true,
      "search": true
      searchConfig:
        key: "username"
        type: "text"
        like: true
    },
    "email": {
      "label": "index.contactus.email",
      "type": "text",
      "search": true
      "sort": true
      searchConfig:
        key: "email"
        type: "text"
        like: true
    },
    "phone": {
      "label": "index.contactus.phone",
      "type": "text",
      "search": true
      searchConfig:
        key: "phone"
        type: "text"
        like: true
    },
    "created_at": {
      "label": "index.contactus.created_at",
      "type": "datetime-local",
      "sort": true
      defaultSorting: 'desc'
    },
  },
  "extra": [],
  "action": [
    {
      "name": "view",
      "label": "action.view"
      "roles": ["ROLE_CONTACTUS_WRITE"]
      "route": 'contactus-view'
    }
    {
      "name": "delete",
      "label": "action.delete",
      "roles": ["ROLE_CONTACTUS_WRITE"]
      "component": require 'components/backendbase/partial/list/table/actions/delete.vue'
    }
  ]
}