<?php
namespace Widget\ContactusBundle\Controller\API;

use Backend\BaseBundle\Controller\API\BaseController;
use Backend\BaseBundle\Model\Site;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Method;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Validator\Constraints as Assert;
use Widget\ContactusBundle\Model\Contactus;


/**
 * @Route("/contactus")
 */
class ContactusController extends BaseController
{
    /**
     * 新增contactus的API
     * @Route("/")
     * @Method({"POST"})
     */
    public function createAction(Request $request)
    {
        $parameters = (array) json_decode($request->getContent(), true); //把資料用JSON解碼
        $validator = $this->get('validator'); //驗證格式
        $constraint = new Assert\Collection(array(
            'missingFieldsMessage' => 'error.missing_field',
            'fields' => array(
                'username' => new Assert\NotBlank(array(
                    'message' => 'error.name.missing_field',
                )),
                'email' => array(
                    new Assert\NotBlank(array(
                        'message' => 'error.email.missing_field',
                    )),
                    new Assert\Email(array(
                        'message' => 'error.email.format_incorrect_field',
                    )),
                ),
                'phone' => new Assert\NotBlank(array(
                    'message' => 'error.phone.missing_field',
                )),
                'content' => new Assert\NotBlank(array(
                    'message' => 'error.content.missing_field',
                )),
            ),
        )); //驗證資料的驗證格式規範

        $errors = $validator->validate($parameters, $constraint); //把資料驗證(資料, 驗證格式)

        //判斷回傳是否有錯誤 等於0沒錯
        if(count($errors) > 0){
            return $this->createJsonResponse($this->get('api.validator.error.convertor')->toArray($errors), Response::HTTP_BAD_REQUEST);
        }

        //幫你做一次SQL
        $contactus = new Contactus();
        //把資料寫進資料庫
        $contactus->fromArray($parameters, \BasePeer::TYPE_FIELDNAME);
        //把資料儲存
        $contactus->save();
        //傳回一個成功的值
        return $this->createJsonResponse(array(
            'id' => $contactus->getId(),
        ));
    }
}
