<?php

namespace Widget\ContacterBundle\Controller\API;

use Backend\BaseBundle\Controller\API\BaseController;
use Backend\BaseBundle\Model\Site;
use Backend\BaseBundle\Service\ConstraintViolationListConvertor;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Method;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\ParamConverter;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Validator\Constraints as Assert;
use Symfony\Component\Validator\Validator\ValidatorInterface;
use Widget\ContacterBundle\Model\Contacter;
use Widget\ContacterBundle\Model\ContacterQuery;
use Widget\MemberBundle\Token\MemberAuthToken;

/**
 * @Route("/contacter")
 */
class ContacterController extends BaseController
{
    /**
     * @Route("/")
     * @Method("GET")
     */
    public function contacterListAction(Request $request)
    {
        $member = $request->attributes->get('_authorizedToken');
        if(!($member instanceof MemberAuthToken) || $member->getAuthData() == null){
            return new Response('', Response::HTTP_FORBIDDEN);
        }

        $result = ContacterQuery::create()
            ->filterByMemberId($member->getAuthData()['uid'])
            ->find();
        
        return $this->createJsonSerializeResponse($result, array('list'));
    }

    /**
     * @Route("/create")
     * @Method("POST")
     */
    public function createAction(Request $request)
    {
        $parameters = $request->request->all();
        
        $constraint = new Assert\Collection(array(
            'missingFieldsMessage' => 'error.missing_field',
            'fields' => array(
                'name' => new Assert\NotBlank(),
                'member_id' => new Assert\NotBlank() ,
                'email' => array(
                    new Assert\NotBlank(),
                    new Assert\Email(),
                ),
                'phone' => new Assert\NotBlank(),
                'zip' => new Assert\NotBlank(),
                'address' => new Assert\NotBlank(),
            ),
        ));
        $validator = $this->get('validator');
        $errors = $validator->validate($parameters, $constraint);

        if(count($errors) > 0){
            return $this->createJsonResponse($this->get('api.validator.error.convertor')->toArray($errors), Response::HTTP_BAD_REQUEST);
        }
        
        $contacter = new Contacter();
        $contacter->fromArray($parameters, \BasePeer::TYPE_FIELDNAME);
        $contacter->save();
        
        return $this->createJsonResponse(array(
            'id' => $contacter->getId(),
        ));        
    }
}