<?php

namespace Widget\ContacterBundle\Tests\Controller\API;

use Backend\BaseBundle\Tests\Fixture\BaseWebTestCase;
use Symfony\Component\HttpFoundation\Response;
use Widget\ContacterBundle\Model\ContacterQuery;
use Widget\MemberBundle\Model\Member;
use Widget\MemberBundle\Token\MemberAuthToken;

class ContacterControllerTest extends BaseWebTestCase
{
    private $conacterId;

    public function setUp()
    {
        parent::setUp();
        $this->conacterId = null;
    }

    protected function tearDown()
    {
        if($this->conacterId){
            ContacterQuery::create()
                ->findPk($this->conacterId)
                ->delete();
        }
        parent::tearDown();
    }
    
    public function test_contacterListAction_no_auth()
    {
        // arrange
        $slug = "dgfactor";
        $id = "1001";  // 同 fixtures 資料

        // act
        $this->client->request('GET', $this->generateUrl('widget_contacter_api_contacter_contacterlist', array('slug' => $slug , 'id' => $id)));
        $result = $this->client->getResponse();

        // assert
        $this->assertTrue($result->isForbidden());
    }

    public function test_contacterListAction()
    {
        // arrange
        $slug = "dgfactor";
        $id = "1001";
        $expectJson = array(
            array(
                'name' => 'yang',
                'email' => 'yang@dgfactor.com.tw',
                'zip' => '321',
                'address' => '大大路',
                'phone' => '0912345678'
            ),
            array(
                'name' => 'yang',
                'email' => 'yang@dgfactor.com.tw',
                'zip' => '321',
                'address' => '大大路',
                'phone' => '0912345678'
            ),
            array(
                'name' => 'yang',
                'email' => 'yang@dgfactor.com.tw',
                'zip' => '321',
                'address' => '大大路',
                'phone' => '0912345678'
            ),
        );

        $secret = $this->client->getContainer()->getParameter('secret');
        $origin = "http://localhost";
        $member = new Member();
        $member->setId($id);
        $member->setSiteId(12345);
        $authToken = new MemberAuthToken($secret, $origin, $origin);
        $authToken->setMember($member);
        $token = $authToken->getJWTToken();

        // act
        $this->client->request(
            'GET',
            $this->generateUrl('widget_contacter_api_contacter_contacterlist', array('slug' => $slug, 'id' => $id)),
            array(),
            array(),
            array(
                'HTTP_ORIGIN' => $origin,
                'HTTP_AUTHORIZATION' => "Bearer $token",
            )
        );
        $response = $this->client->getResponse();
        $responseJson = json_decode($response->getContent(), true);

        // assert
        $this->assertTrue($response->isOk());
        $this->assertEquals($expectJson, $responseJson);
    }

    public function test_createAction_empty_name()
    {
        // arrange
        $slug = "dgfactor";
        $name = "";
        $memberId = "1001";
        $email = "HsinchuLinCiSian@yahoo.com.tw";
        $phone = "091234578";
        $zip = "811";
        $address = "高雄市楠梓百慕達高架橋";
        $parameters = array(
            'member_id' => $memberId,
            'name' => $name,
            'email' => $email,
            'phone' => $phone,
            'zip' => $zip,
            'address' => $address,
        );

        // act
        $this->client->request(
            'POST',
            $this->generateUrl('widget_contacter_api_contacter_create', array('slug' => $slug)),
            $parameters
        );
        $response = $this->client->getResponse();

        // assert
        $this->assertEquals(Response::HTTP_BAD_REQUEST, $response->getStatusCode());
    }

    public function test_createAction_empty_email()
    {
        // arrange
        $slug = "dgfactor";
        $name = "新竹林七賢";
        $memberId = "1001";
        $email = "";
        $phone = "091234578";
        $zip = "811";
        $address = "高雄市楠梓百慕達高架橋";
        $parameters = array(
            'member_id' => $memberId,
            'name' => $name,
            'email' => $email,
            'phone' => $phone,
            'zip' => $zip,
            'address' => $address,
        );

        // act
        $this->client->request(
            'POST',
            $this->generateUrl('widget_contacter_api_contacter_create', array('slug' => $slug)),
            $parameters
        );
        $response = $this->client->getResponse();

        // assert
        $this->assertEquals(Response::HTTP_BAD_REQUEST, $response->getStatusCode());
    }

    public function test_createAction_empty_phone()
    {
        // arrange
        $slug = "dgfactor";
        $name = "新竹林七賢";
        $memberId = "1001";
        $email = "HsinchuLinCiSian@yahoo.com.tw";
        $phone = "";
        $zip = "811";
        $address = "高雄市楠梓百慕達高架橋";
        $parameters = array(
            'member_id' => $memberId,
            'name' => $name,
            'email' => $email,
            'phone' => $phone,
            'zip' => $zip,
            'address' => $address,
        );

        // act
        $this->client->request(
            'POST',
            $this->generateUrl('widget_contacter_api_contacter_create', array('slug' => $slug)),
            $parameters
        );
        $response = $this->client->getResponse();

        // assert
        $this->assertEquals(Response::HTTP_BAD_REQUEST, $response->getStatusCode());
    }

    public function test_createAction_empty_zip()
    {
        // arrange
        $slug = "dgfactor";
        $name = "新竹林七賢";
        $memberId = "1001";
        $email = "HsinchuLinCiSian@yahoo.com.tw";
        $phone = "091234578";
        $zip = "";
        $address = "高雄市楠梓百慕達高架橋";
        $parameters = array(
            'member_id' => $memberId,
            'name' => $name,
            'email' => $email,
            'phone' => $phone,
            'zip' => $zip,
            'address' => $address,
        );

        // act
        $this->client->request(
            'POST',
            $this->generateUrl('widget_contacter_api_contacter_create', array('slug' => $slug)),
            $parameters
        );
        $response = $this->client->getResponse();

        // assert
        $this->assertEquals(Response::HTTP_BAD_REQUEST, $response->getStatusCode());
    }

    public function test_createAction_empty_address()
    {
        // arrange
        $slug = "dgfactor";
        $name = "新竹林七賢";
        $memberId = "1001";
        $email = "HsinchuLinCiSian@yahoo.com.tw";
        $phone = "091234578";
        $zip = "811";
        $address = "";
        $parameters = array(
            'member_id' => $memberId,
            'name' => $name,
            'email' => $email,
            'phone' => $phone,
            'zip' => $zip,
            'address' => $address,
        );

        // act
        $this->client->request(
            'POST',
            $this->generateUrl('widget_contacter_api_contacter_create', array('slug' => $slug)),
            $parameters
        );
        $response = $this->client->getResponse();

        // assert
        $this->assertEquals(Response::HTTP_BAD_REQUEST, $response->getStatusCode());
    }

    public function test_createAction()
    {
        // arrange
        $slug = "dgfactor";
        $name = "新竹林七賢";
        $memberId = "1001";
        $email = "HsinchuLinCiSian@yahoo.com.tw";
        $phone = "091234578";
        $zip = "811";
        $address = "高雄市楠梓百慕達高架橋";
        $parameters = array(
            'member_id' => $memberId,
            'name' => $name,
            'email' => $email,
            'phone' => $phone,
            'zip' => $zip,
            'address' => $address,
        );

        // act
        $this->client->request(
            'POST',
            $this->generateUrl('widget_contacter_api_contacter_create', array('slug' => $slug)),
            $parameters
        );

        $response = $this->client->getResponse();

        $responseJson = json_decode($response->getContent(), true);
        $this->conacterId = $responseJson['id'];
        $contacter = ContacterQuery::create()
            ->findPk($this->conacterId);

        // assert
        $this->assertTrue($response->isOk());
        $this->assertEquals($name, $contacter->getName());
        $this->assertEquals($memberId, $contacter->getMemberId());
        $this->assertEquals($email, $contacter->getEmail());
        $this->assertEquals($phone, $contacter->getPhone());
        $this->assertEquals($zip, $contacter->getZip());
        $this->assertEquals($address, $contacter->getAddress());
    }
}