<?php

namespace Widget\CategoryBundle\Tests\Service;

use Backend\BaseBundle\Model\SiteUser;
use Backend\BaseBundle\Service\OperationLogger;
use Backend\BaseBundle\Tests\Fixture\BaseWebTestCase;
use Symfony\Component\Security\Core\Authentication\Token\Storage\TokenStorage;
use Symfony\Component\Security\Core\Authentication\Token\TokenInterface;
use Widget\CategoryBundle\Model\Category;
use Widget\CategoryBundle\Service\CategoryOperationLogger;

class CategoryOperationLoggerTest extends BaseWebTestCase
{
    public function test_injectOperationlog()
    {
        // arrange
        $log = $this->getMockBuilder(CategoryOperationLogger::class)
            ->setMethods()
            ->disableOriginalConstructor()
            ->getMock();
        $operationLogger = $this->getMockBuilder(OperationLogger::class)
            ->disableOriginalConstructor()
            ->setMethods()
            ->getMock();

        // act
        $log->injectOperationlog($operationLogger);

        // assert
        $this->assertInstanceOf(OperationLogger::class, $this->getObjectAttribute($log, 'operationlog'));
    }
    
    public function test_TokenStorage()
    {
        // arrange
        $log = $this->getMockBuilder(CategoryOperationLogger::class)
            ->disableOriginalConstructor()
            ->setMethods()
            ->getMock();
        $securityTokenStorage = $this->getMockBuilder(TokenStorage::class)
            ->setMethods()
            ->disableOriginalConstructor()
            ->getMock();

        // act
        $log->injectTokenStorage($securityTokenStorage);

        // assert
        $this->assertInstanceOf(TokenStorage::class, $this->getObjectAttribute($log, 'securityTokenStorage'));
    }
    
    public function test_getUser_null()
    {
        // arrange
        $log = $this->getMockBuilder(CategoryOperationLogger::class)
            ->setMethods()
            ->disableOriginalConstructor()
            ->getMock();
        $securityTokenStorage = $this->getMockBuilder(TokenStorage::class)
            ->setMethods(array('getToken'))
            ->disableOriginalConstructor()
            ->getMock();
        $securityTokenStorage
            ->expects($this->once())
            ->method('getToken')
            ->willReturn(null);
        $this->setObjectAttribute($log, 'securityTokenStorage', $securityTokenStorage);

        // act
        $result = $log->getUser();

        // assert
        $this->assertEquals(null, $result);
    }

    public function test_getUser_not_object()
    {
        // arrange
        $log = $this->getMockBuilder(CategoryOperationLogger::class)
            ->setMethods()
            ->disableOriginalConstructor()
            ->getMock();
        $token = $this->getMockBuilder(TokenInterface::class)->getMock();
        $securityTokenStorage = $this->getMockBuilder(TokenStorage::class)
            ->setMethods(array('getToken'))
            ->disableOriginalConstructor()
            ->getMock();

        $token
            ->expects($this->once())
            ->method('getUser')
            ->willReturn('Not Object');

        $securityTokenStorage
            ->expects($this->once())
            ->method('getToken')
            ->willReturn($token);

        $this->setObjectAttribute($log, 'securityTokenStorage', $securityTokenStorage);

        // act
        $result = $log->getUser();

        // assert
        $this->assertEquals(null, $result);
    }

    public function test_getUser_ok()
    {
        // arrange
        $log = $this->getMockBuilder(CategoryOperationLogger::class)
            ->setMethods()
            ->disableOriginalConstructor()
            ->getMock();
        $token = $this->getMockBuilder(TokenInterface::class)->getMock();
        $securityTokenStorage = $this->getMockBuilder(TokenStorage::class)
            ->setMethods(array('getToken'))
            ->disableOriginalConstructor()
            ->getMock();
        $fakeUserObject = (object)array('fakeUserObject' => 'testtest');

        $token
            ->expects($this->once())
            ->method('getUser')
            ->willReturn($fakeUserObject);

        $securityTokenStorage
            ->expects($this->once())
            ->method('getToken')
            ->willReturn($token);

        $this->setObjectAttribute($log, 'securityTokenStorage', $securityTokenStorage);

        // act
        $result = $log->getUser();

        // assert
        $this->assertEquals($fakeUserObject, $result);
    }
    
    public function test_logOperation()
    {
        // arrange
        $fakeSiteUser = new SiteUser();
        $tableName = "category";

        $log = $this->getMockBuilder(CategoryOperationLogger::class)
            ->setMethods(array('getUser'))
            ->disableOriginalConstructor()
            ->getMock();
        $operationLogger = $this->getMockBuilder(OperationLogger::class)
            ->setMethods(array('log'))
            ->disableOriginalConstructor()
            ->getMock();
        $category = new Category();
        $this->setObjectAttribute($category, '_new', true);
        
        $log
            ->expects($this->once())
            ->method('getUser')
            ->willReturn($fakeSiteUser);
        $operationLogger
            ->expects($this->once())
            ->method('log')
            ->willReturnCallback(function($user, $type, $table, $column) use ($fakeSiteUser, $tableName){
                $this->assertEquals($user, $fakeSiteUser);
                $this->assertEquals($type, 'new');
                $this->assertEquals($table, $tableName);
            });

        $this->setObjectAttribute($log, 'operationlog', $operationLogger);
        
        // act
        $log->logOperation($category);

        // assert
    }
}