<?php
namespace Widget\CategoryBundle\Test\Controller\Backend;

use Backend\BaseBundle\Model\SiteUserQuery;
use Backend\BaseBundle\Tests\Fixture\BackendWebTestCase;
use Widget\PhotoBundle\Model\PhotoConfig;
use Widget\PhotoBundle\Model\PhotoConfigQuery;

class CategoryControllerTest extends BackendWebTestCase
{

    public function test_no_rights_should_not_enter_index()
    {
        //arrange
        $slug = 'dgfactor';
        $thread = 'product';
        $user = SiteUserQuery::create()->findOneByLoginName('admin');
        $this->loginWithRoles($user);

        //act
        $crawler = $this->client->request('GET', $this->generateUrl('widget_category_backend_category_index', array('slug' => $slug, 'thread' => $thread)));
        $response = $this->client->getResponse();

        //assert
        $this->assertFalse($response->isOk());
    }

    public function test_has_rights_can_enter_index()
    {
        //arrange
        $slug = 'dgfactor';
        $thread = 'product';
        $user = SiteUserQuery::create()->findOneByLoginName('admin');
        $roles = array('ROLE_CATEGORY_READ');
        $this->loginWithRoles($user, $roles);

        //act
        $crawler = $this->client->request('GET', $this->generateUrl('widget_category_backend_category_index', array('slug' => $slug, 'thread' => $thread)));
        $response = $this->client->getResponse();

        //assert
        $this->assertTrue($response->isOk());
    }

    public function test_no_rights_should_not_see_create()
    {
        //arrange
        $slug = 'dgfactor';
        $thread = 'product';
        $user = SiteUserQuery::create()->findOneByLoginName('admin');
        $roles = array('ROLE_CATEGORY_READ');
        $this->loginWithRoles($user, $roles);

        //act
        $crawler = $this->client->request('GET', $this->generateUrl('widget_category_backend_category_index', array('slug' => $slug, 'thread' => $thread)));
        $response = $this->client->getResponse();

        //assert
        $this->assertTrue($response->isOk());
        $this->assertEquals(0, $crawler->filter('#tree-row-btn-template [data-action="create"]')->count());
        $this->assertEquals(0, $crawler->filter('#tree-row-btn-template [data-action="edit"]')->count());
        $this->assertEquals(0, $crawler->filter('#tree-row-btn-template [data-action="delete"]')->count());
    }

    public function test_has_rights_should_should_see_create()
    {
        //arrange
        $slug = 'dgfactor';
        $thread = 'product';
        $user = SiteUserQuery::create()->findOneByLoginName('admin');
        $roles = array('ROLE_CATEGORY_READ', 'ROLE_CATEGORY_WRITE');
        $this->loginWithRoles($user, $roles);

        //act
        $crawler = $this->client->request('GET', $this->generateUrl('widget_category_backend_category_index', array('slug' => $slug, 'thread' => $thread)));
        $response = $this->client->getResponse();

        //assert
        $this->assertTrue($response->isOk());
        $this->assertGreaterThan(0, $crawler->filter('#tree-row-btn-template [data-action="create"]')->count());
        $this->assertGreaterThan(0, $crawler->filter('#tree-row-btn-template [data-action="edit"]')->count());
        $this->assertGreaterThan(0, $crawler->filter('#tree-row-btn-template [data-action="delete"]')->count());
    }

    public function test_no_rights_should_not_grag()
    {
        //arrange
        $slug = 'dgfactor';
        $thread = 'product';
        $user = SiteUserQuery::create()->findOneByLoginName('admin');
        $roles = array('ROLE_CATEGORY_READ');
        $this->loginWithRoles($user, $roles);

        //act
        $crawler = $this->client->request('GET', $this->generateUrl('widget_category_backend_category_index', array('slug' => $slug, 'thread' => $thread)));
        $response = $this->client->getResponse();

        //assert
        $this->assertTrue($response->isOk());
        $this->assertEmpty($crawler->filter('#admin-category')->attr('data-allow-drag'));
    }


    public function test_has_rights_should_see_grag()
    {
        //arrange
        $slug = 'dgfactor';
        $thread = 'product';
        $user = SiteUserQuery::create()->findOneByLoginName('admin');
        $roles = array('ROLE_CATEGORY_READ', 'ROLE_CATEGORY_WRITE');
        $this->loginWithRoles($user, $roles);

        //act
        $crawler = $this->client->request('GET', $this->generateUrl('widget_category_backend_category_index', array('slug' => $slug, 'thread' => $thread)));
        $response = $this->client->getResponse();

        //assert
        $this->assertTrue($response->isOk());
        $this->assertNotEmpty($crawler->filter('#admin-category')->attr('data-allow-drag'));
    }

}