<?php

namespace Widget\CategoryBundle\Service;

use Backend\BaseBundle\Model\OperationLogPeer;
use JMS\DiExtraBundle\Annotation as DI;

/**
 * @DI\Service("widget.category.operationlog")
 */
class CategoryOperationLogger
{
    protected $operationlog;
    protected $securityTokenStorage;
    /**
     * @DI\InjectParams({
     *     "operationlog" = @DI\Inject("backend.base_bundle.operationlog")
     * })
     */
    public function injectOperationlog($operationlog)
    {
        $this->operationlog = $operationlog;
    }

    /**
     * @DI\InjectParams({
     *     "securityTokenStorage" = @DI\Inject("security.token_storage")
     * })
     */
    public function injectTokenStorage($securityTokenStorage)
    {
        $this->securityTokenStorage = $securityTokenStorage;
    }

    public function getUser()
    {
        if (null === $token = $this->securityTokenStorage->getToken()) {
            return;
        }

        if (!is_object($user = $token->getUser())) {
            // e.g. anonymous authentication
            return;
        }

        return $user;
    }

    public function logOperation(\BaseObject $object)
    {
        $modify = array();
        foreach($object->getModifiedColumns() as $column){
            list($tableName, $columnName) = explode('.', $column);
            $modify[$columnName] = $object->getByName($columnName, \BasePeer::TYPE_FIELDNAME);
        }
        $peer = $object->getPeer();
        $tableName = $peer::TABLE_NAME;
        $this->operationlog->log(
            $this->getUser(),
            $object->isNew()?OperationLogPeer::MODIFY_TYPE_NEW:($object->isDeleted()?OperationLogPeer::MODIFY_TYPE_DELETE:OperationLogPeer::MODIFY_TYPE_UPDATE),
            $tableName,
            $object->isDeleted()?$object->toArray(\BasePeer::TYPE_FIELDNAME):$modify
        );
    }
}