readFromDOM = ($dom) ->
  data = []
  $dom.find('>ul >li').each (index, row) ->
    data.push
      id:         $(row).attr 'data-id'
      status:         $(row).attr 'data-status'
      label:      $(row).find('>span').text()
      children:   readFromDOM $(row)
  data

$ () ->
  dragging = false
  nodeData = null
  origin =
    parent: null
    prevSibling: null
    nextSibling: null

  restoreNode = () ->
    $('#admin-category').tree('loadData', nodeData);
    return
  getDepth = (node) ->
    depth = 0
    while node.parent
      node = node.parent
      depth++
    depth
  markTail = (id) ->
    maxDepth = parseInt($('#admin-category').attr 'data-max-depth')
    node = $('#admin-category').tree 'getNodeById', id
    depth = getDepth node
    $li = $("#admin-category li[data-node-id=#{id}]")
    if depth >= maxDepth
      $li.addClass 'tail-node'
    else
      $li.removeClass 'tail-node'
    return
  data = readFromDOM $('#admin-category')
  syncStatus = ($li) ->
    node = $('#admin-category').tree 'getNodeById', $li.attr 'data-node-id'
    if node.status
      $li.attr 'data-status', '1'
      faclass = 'fa fa-check'
    else
      $li.attr 'data-status', '0'
      faclass = 'fa fa-times'
    $li.find('>div >span >i').remove()
    $li.find('>div >span').prepend "<i class='#{faclass}'></i>"
    return
  $('#admin-category').empty()
  $('#admin-category').tree
      data:    data
      autoOpen: true
      dragAndDrop: !!$('#admin-category').attr('data-allow-drag')
      onCanMoveTo: (moved_node, target_node, position) ->
        nodeData = JSON.parse $('#admin-category').tree 'toJson'
        maxDepth = parseInt($('#admin-category').attr 'data-max-depth')
        if position == 'after'
          if moved_node.parent == target_node.parent
            dragging = true
            return true
          dragging = getDepth(target_node) <= maxDepth
          return dragging
        if position == 'inside'
          return dragging = getDepth(target_node) < maxDepth
        dragging = true
      onCreateLi: (node, $li) ->
        node.status = !! + node.status
        $li.attr 'data-node-id', node.id
        syncStatus $li
        return
  $('#admin-category').on "tree.move", (event) ->
    dragging = false
    $.ajax
      type:    'PUT'
      url:     "#{event.move_info.moved_node.id}/moveto"
      data:    JSON.stringify
        target_id:  event.move_info.target_node.id
        position:   event.move_info.position
      dataType:     'JSON'
      success: (data) ->
        markTail data.id
        return
      error: (data) ->
        restoreNode()
        return
    return
  $('#admin-category').on('mouseenter', '.jqtree-element', (e, data) ->
    return if dragging
    $jqTreeElement = $(@)
    if $jqTreeElement.find('>.btn-group').length == 0
      $jqTreeElement.append $('#tree-row-btn-template').html()
      markTail $jqTreeElement.parent().attr 'data-node-id'
    $jqTreeElement.find('>.btn-group').addClass('visible')
    return
  )
  $('#admin-category').on('mouseleave', '.jqtree-element', (e, data) ->
    $jqTreeElement = $(@)
    $jqTreeElement.find('>.btn-group').removeClass('visible')
    return
  )
  $('#admin-category').on 'click', '[data-action=create]', (e) ->
    return if $(@).attr('data-confirm') && !confirm($(@).attr('data-confirm'))
    node = $('#admin-category').tree 'getNodeById', $(@).parents('li').attr 'data-node-id'
    $('#create-modal').attr 'data-rest-action', "#{node.id}"
    $('#create-modal').attr 'data-rest-method', "post"
    $('#create-modal').find('form')[0].reset()
    $('#create-modal').find('form .has-error').removeClass 'has-error'
    $('#create-modal').modal()
    $('#create-modal').trigger 'modal-open',
      thread: $('#admin-category').attr('data-thread')
      data: node
    $.data $('#create-modal')[0], 'node-data', {
      node: node
      cb: (result) ->
        $('#admin-category').tree 'appendNode',
            label:   result.name
            id:      result.id
            status:  result.status
        , node
        markTail result.id
        return
    }
    return
  $('#admin-category').on 'click', '[data-action=edit]', (e) ->
    return if $(@).attr('data-confirm') && !confirm($(@).attr('data-confirm'))
    node = $('#admin-category').tree 'getNodeById', $(@).parents('li').attr 'data-node-id'
    if node.status
      status = '1'
    else
      status = '0'
    $('#edit-modal').attr 'data-rest-action', "#{node.id}"
    $('#edit-modal').attr 'data-rest-method', "put"
    $('#edit-modal').find('form [name=name]').val node.name
    $('#edit-modal').find('form [name=status]').val status
    $('#edit-modal').find('form .has-error').removeClass 'has-error'
    $('#edit-modal').modal()
    $('#edit-modal').trigger 'modal-open',
      thread: $('#admin-category').attr('data-thread')
      data: node
    $.data $('#edit-modal')[0], 'node-data', {
      node: node
      cb: (result) ->
        syncStatus $("#admin-category li[data-node-id=#{node.id}]")
        return
    }
    return
  $('#admin-category').on 'click', '[data-action=delete]', (e) ->
    return if $(@).attr('data-confirm') && !confirm($(@).attr('data-confirm'))
    node = $('#admin-category').tree 'getNodeById', $(@).parents('li').attr 'data-node-id'
    $.ajax
      type:    'delete'
      url:     "#{node.id}"
      dataType:     'JSON'
      success: (data) ->
        $('#admin-category').tree 'removeNode', node
        return
      error: (data) ->
        restoreNode()
        return
    return
  $('.modal').on 'click', '[data-action=save]', () ->
    params = {}
    $modal = $(@).parents('.modal')
    nodedata = $.data $modal[0], 'node-data'
    $.each $modal.find('form').serializeArray(), (index, item) ->
      params[item.name] = item.value
    if $.trim(params.name) == ''
      $('input[name=name]').parent().parent().addClass 'has-error'
      return
    $.ajax
      type:    $modal.attr 'data-rest-method'
      url:     $modal.attr 'data-rest-action'
      data:    JSON.stringify params
      dataType:     'JSON'
      success: (data) ->
        if nodedata.node.id == data.id
            $('#admin-category').tree 'updateNode', nodedata.node, data.name
            nodedata.node.status = data.status
            nodedata.node.name = data.name
        nodedata.cb data
        $('[data-category-modal]:visible').trigger 'category-updated',
          thread: $('#admin-category').attr('data-thread')
          data: data
        $modal.modal('hide')
        return
      error: (data) ->
        restoreNode()
        return
    return
  return