<?php
namespace Widget\CategoryBundle\EventListener\ControllerConfig;

use JMS\DiExtraBundle\Annotation as DI;
use JMS\DiExtraBundle\Annotation\Service;
use JMS\DiExtraBundle\Annotation\Inject;
use JMS\DiExtraBundle\Annotation\InjectParams;
use Backend\BaseBundle\Event\Controller;
use Symfony\Component\Routing\Router;

/**
 * @Service
 */
class CategoryListener
{
    const CONTROLLER_NAME = 'WidgetCategoryBundle:Backend/Category';

    /** @var  Router */
    protected $router;

    /**
     * @InjectParams()
     */
    public function injectRouter(Router $router)
    {
        $this->router = $router;
    }

    /**
     * @DI\Observe(Controller\TypeRolesEvent::EVENT_TYPE_ROLES)
     */
    public function onTypeRoles(Controller\TypeRolesEvent $event)
    {
        $event->addTypeRoles('ROLE_CATEGORY', array(
            'ROLE_CATEGORY_READ',
            'ROLE_CATEGORY_WRITE',
        ));
    }
}