<?php

namespace Widget\CategoryBundle\Tests\Service;

use Backend\BaseBundle\Tests\Fixture\BaseKernelTestCase;
use Widget\CategoryBundle\Model\Category;
use Widget\CategoryBundle\Model\CategoryI18nQuery;
use Widget\CategoryBundle\Model\CategoryPeer;
use Widget\CategoryBundle\Model\CategoryQuery;
use Widget\CategoryBundle\Model\CategoryThreadQuery;
use Widget\CategoryBundle\Service\CategoryService;

class CategoryServiceTest extends BaseKernelTestCase
{
    public function test_create()
    {
        //arrange
        $service = new CategoryService();
        $thread = "food";
        $locale = "zh_TW";
        $name = 'root';

        //act
        $result = $this->callObjectMethod($service, "create", $thread, $locale);

        $cateThread = CategoryThreadQuery::create()
            ->filterByThread($thread)
            ->findOne();

        $rootCate = CategoryQuery::create()
            ->findRoot($cateThread->getId());

        $rootCate->setLocale($locale);

        $cateLocale = CategoryI18nQuery::create()
            ->filterByCategory($rootCate)
            ->findOne();

        //assert
        $this->assertEquals($name, $result->getName());
        $this->assertEquals($name, $rootCate->getName());

        //teardown
        CategoryPeer::deleteTree($cateThread->getId());
        $cateThread->delete();
        $cateLocale->delete();
    }

    public function test_read()
    {
        //arrange
        $service = new CategoryService();
        $thread = "product";
        $name = 'root';
        $locale = "en_US";

        //act
        $result = $this->callObjectMethod($service, "read", $thread, $locale);

        //assert
        $this->assertTrue($result instanceof Category);
        $this->assertEquals($name, $result->getName());
    }

    public function test_makeRootTypeCategory_拿thread找得到category()
    {
        //arrange
        $thread = "product";
        $locale = "en_US";
        $cate = CategoryQuery::create()->findOne();

        $service = $this->getMockBuilder(CategoryService::class)
            ->setMethods(array("read", "create"))
            ->getMock();

        $service->expects($this->once())
            ->method("read")
            ->with($thread, $locale)
            ->willReturn($cate);

        $service->expects($this->never())
            ->method("create")
            ;

        //act
        $result = $service->makeRootTypeCategory($thread, $locale);

        //assert
        $this->assertTrue($result instanceof Category);
    }

    public function test_makeRootTypeCategory_拿thread找不到category()
    {
        //arrange
        $thread = "product";
        $locale = "en_US";
        $cate = CategoryQuery::create()->findOne();

        $service = $this->getMockBuilder(CategoryService::class)
            ->setMethods(array("read", "create"))
            ->getMock();

        $service->expects($this->once())
            ->method("read")
            ->with($thread, $locale)
            ->willReturn(null);

        $service->expects($this->once())
            ->method("create")
            ->with($thread, $locale)
            ->willReturn($cate)
            ;

        //act
        $result = $service->makeRootTypeCategory($thread, $locale);

        //assert
        $this->assertTrue($result instanceof Category);
    }

    public function test_delete()
    {
        //arrange
        $service = new CategoryService();
        $thread = CategoryThreadQuery::create()->findOne();
        $newCate = new Category();
        $newCate->setCategoryThread($thread);
        $newCate->save();

        //act
        $service->delete($newCate);

        //assert
        $this->assertTrue($newCate->isDeleted());
    }
}
