<?php

namespace Widget\CategoryBundle\Service;

use JMS\DiExtraBundle\Annotation as DI;
use Widget\CategoryBundle\Model\Category;
use Widget\CategoryBundle\Model\CategoryQuery;
use Widget\CategoryBundle\Model\CategoryThread;

/**
 * @DI\Service("category_service")
 */
class CategoryService
{
    /**
     * @param string $thread
     * @param string $locale
     * @param \PropelPDO|null $conn
     * @return Category
     */
    public function makeRootTypeCategory($thread, $locale, \PropelPDO $conn = null): Category
    {
        $result = $this->read($thread, $locale, $conn);
        if ($result instanceof Category) {
            return $this->translate($result, $locale);
        }

        $result = $this->create($thread, $locale, $conn);
        return $this->translate($result, $locale);
    }

    /**
     * @param Category $category
     * @param \PropelPDO|null $conn
     */
    public function delete(Category $category, \PropelPDO $conn = null)
    {
        $category->delete($conn);
    }

    /**
     * @param $thread
     * @param $locale
     * @param \PropelPDO|null $conn
     * @return Category|null
     */
    protected function read($thread, $locale, \PropelPDO $conn = null)
    {
        return CategoryQuery::create()
            ->joinWithI18n($locale)
            ->filterByTreeLevel(0)
            ->useCategoryThreadQuery()
                ->filterByThread($thread)
            ->endUse()
            ->findOne($conn);
    }

    /**
     * @param string $thread
     * @param string $locale
     * @param \PropelPDO|null $conn
     * @return Category
     */
    protected function create(string $thread, string $locale, \PropelPDO $conn = null)
    {
        $categoryThread = new CategoryThread();
        $categoryThread->setThread($thread);

        $rootCategory = new Category();
        $rootCategory->setCategoryThread($categoryThread)
            ->setLocale($locale)
            ->setName("root")
            ->makeRoot()
            ->save($conn);

        return $rootCategory;
    }

    protected function translate(Category $category, $locale)
    {
        foreach ($category->getBranch() as $node) {
            $node->setLocale($locale);
        }
        return $category;
    }
}
