<?php
namespace Widget\CategoryBundle\Controller\API;

use Backend\BaseBundle\Controller\API\BaseController;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Method;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\ParamConverter;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Widget\CategoryBundle\Model\Category;
use Widget\CategoryBundle\Model\CategoryQuery;

/**
 * @Route("/category")
 */
class CategoryController extends BaseController
{
    /**
     * 取得Root Category的API
     * @Route("/root/{thread}")
     * @Method({"GET"})
     */
    public function getRootCategoryAction(Request $request, $thread)
    {
        if (is_null($locale = $request->attributes->get("_locale"))) {
            return $this->createHttpExceptionResponse(Response::HTTP_BAD_REQUEST);
        }

        /** @var Category $rootCategory */
        if(!$rootCategory = CategoryQuery::create()
            ->joinWithI18n($locale)
            ->filterByTreeLevel(0)
            ->filterByStatus(true)
            ->useCategoryThreadQuery()
            ->filterByThread($thread)
            ->endUse()
            ->findOne()){
            return $this->createHttpExceptionResponse(Response::HTTP_NOT_FOUND);
        }

        return $this->createJsonSerializeResponse(
            $rootCategory->getChildren(CategoryQuery::create()->filterByStatus(true)),
            array('detail')
        );
    }

    /**
     * 取得Category的API(下層分支)
     * @Route("/{id}")
     * @ParamConverter("site", options={"exclude": {"id"}})
     * @Method({"GET"})
     */
    public function getCategoryAction(Request $request, Category $category)
    {
        if (is_null($locale = $request->attributes->get("_locale"))) {
            return $this->createHttpExceptionResponse(Response::HTTP_BAD_REQUEST);
        }

        $query = CategoryQuery::create()
            ->joinWithI18n($locale)
            ->filterByStatus(true);
        if (!$children = $category->getChildren($query)){
            return $this->createHttpExceptionResponse(Response::HTTP_NOT_FOUND);
        }

        return $this->createJsonSerializeResponse($children, array('list'));
    }

    /**
     * 取得Category Ancestors的API(上層分支)
     * @Route("/{id}/ancestors")
     * @ParamConverter("site", options={"exclude": {"id"}})
     * @Method({"GET"})
     */
    public function getCategoryAncestorsAction(Request $request, Category $category)
    {
        if (is_null($locale = $request->attributes->get("_locale"))) {
            return $this->createHttpExceptionResponse(Response::HTTP_BAD_REQUEST);
        }

        if (!$ancestors = CategoryQuery::create()
            ->joinWithI18n($locale)
            ->filterByStatus(true)
            ->inTree($category->getScopeValue())
            ->filterByTreeLeft($category->getLeftValue(), \Criteria::LESS_EQUAL)
            ->filterByTreeRight($category->getRightValue(), \Criteria::GREATER_EQUAL)
            ->orderByBranch()
            ->find()){
            return $this->createHttpExceptionResponse(Response::HTTP_NOT_FOUND);
        }

        return $this->createJsonSerializeResponse($ancestors, array('list'));
    }
}