<?php

namespace Widget\CategoryArticleBundle\Tests\Controller\BackendAPI;

use Backend\BaseBundle\Model\SiteUserQuery;
use Backend\BaseBundle\Tests\Fixture\BackendWebTestCase;
use Widget\CategoryArticleBundle\Model\CArticle;
use Widget\CategoryArticleBundle\Model\CArticleQuery;

class CategoryArticleControllerTest extends BackendWebTestCase
{
    public function test_createAction()
    {
        //arrange
        $loginName = 'admin';
        $origin = 'http://localhost';
        $token = $this->createToken(SiteUserQuery::create()->findOneByLoginName($loginName), $origin);
        $params = array(
            'title' => 'c_article_title',
            'brief' => 'c_article_brief',
            'content' => 'c_article__content',
            'photos' => 'c_article__photos'
        );

        //act
        $this->client->request(
            'POST',
            $this->generateUrl('widget_categoryarticle_backendapi_categoryarticle_create'),
            array(),
            array(),
            array(
                'HTTP_ORIGIN' => $origin,
                'HTTP_AUTHORIZATION' => "Bearer $token",
            ),
            json_encode($params)
        );
        $response = $this->client->getResponse();
        $result = json_decode($response->getContent(), true);
        CArticleQuery::create()->findOneById($result['id'])->delete();

        //assert

        $this->assertTrue($response->isOk());
        $this->assertEquals($params['title'], $result['title']);
        $this->assertEquals($params['brief'], $result['brief']);
        $this->assertEquals($params['content'], $result['content']);
    }

    public function test_searchAction()
    {
        //arrange
        $loginName = 'admin';
        $origin = 'http://localhost';
        $token = $this->createToken(SiteUserQuery::create()->findOneByLoginName($loginName), $origin);
        $searchParams = array(
            'page' => 1,
            'sort' => array(
                'title' => 'asc'
            ),
            'search' => array(
                'title' => '%5566%',
            ),
        );

        //act
        $this->client->request(
            'GET',
            $this->generateUrl('widget_categoryarticle_backendapi_categoryarticle_search', $searchParams),
            array(),
            array(),
            array(
                'HTTP_ORIGIN' => $origin,
                'HTTP_AUTHORIZATION' => "Bearer $token",
            )
        );
        $response = $this->client->getResponse();
        $responseArray = json_decode($response->getContent(), true);

        //assert
        $this->assertTrue($response->isOk());
        $this->assertArrayHasKey('pager', $responseArray);
        $this->assertArrayHasKey('page', $responseArray['pager']);
        $this->assertArrayHasKey('pages', $responseArray['pager']);
        $this->assertArrayHasKey('rows', $responseArray['pager']);

        $this->assertArrayHasKey('data', $responseArray);
        $this->assertArrayHasKey('title', $responseArray['data'][0]);
        $this->assertArrayHasKey('brief', $responseArray['data'][0]);
    }

    public function test_readAction()
    {
        //arrange
        $loginName = 'admin';
        $origin = 'http://localhost';
        $token = $this->createToken(SiteUserQuery::create()->findOneByLoginName($loginName), $origin);

        //act
        $this->client->request(
            'GET',
            $this->generateUrl('widget_categoryarticle_backendapi_categoryarticle_read', array('id' => 1)),
            array(),
            array(),
            array(
                'HTTP_ORIGIN' => $origin,
                'HTTP_AUTHORIZATION' => "Bearer $token",
            )
        );
        $response = $this->client->getResponse();
        $responseArray = json_decode($response->getContent(), true);
        //assert
        $cArticle = CArticleQuery::create()->findOneById(1);

        $this->assertTrue($response->isOk());
        $this->assertEquals($responseArray['title'], $cArticle->getTitle());
        $this->assertEquals($responseArray['brief'], $cArticle->getBrief());
        $this->assertEquals($responseArray['content'], $cArticle->getContent());
    }

    public function test_updateAction()
    {
        //arrange
        $loginName = 'admin';
        $origin = 'http://localhost';
        $token = $this->createToken(SiteUserQuery::create()->findOneByLoginName($loginName), $origin);
        $cArticleId = 2;
        $params = array(
            'title' => 'c_article_title_update',
            'brief' => 'c_article_brief_update',
            'content' => 'c_article__content_update',
            'photos' => 'c_article__photos_update'
        );
        $originCArticle = CArticleQuery::create()->findOneById($cArticleId)->toArray();
        //act
        $this->client->request(
            'PUT',
            $this->generateUrl('widget_categoryarticle_backendapi_categoryarticle_update', array('id' => $cArticleId)),
            array(),
            array(),
            array(
                'HTTP_ORIGIN' => $origin,
                'HTTP_AUTHORIZATION' => "Bearer $token",
            ),
            json_encode($params)
        );
        $response = $this->client->getResponse();

        //assert
        $cArticle = CArticleQuery::create()->findOneById($cArticleId);
        $this->assertTrue($response->isOk());
        $this->assertEquals($params['title'], $cArticle->getTitle());
        $this->assertEquals($params['brief'], $cArticle->getBrief());
        $this->assertEquals($params['content'], $cArticle->getContent());

        $cArticle->fromArray($originCArticle);
        $cArticle->save();
    }

    public function test_deleteAction()
    {
        //arrange
        $loginName = 'admin';
        $origin = 'http://localhost';
        $token = $this->createToken(SiteUserQuery::create()->findOneByLoginName($loginName), $origin);
        $cArticleId = 2;
        $originCArticle = CArticleQuery::create()->findOneById($cArticleId)->toArray();
        //act
        $this->client->request(
            'DELETE',
            $this->generateUrl('widget_categoryarticle_backendapi_categoryarticle_delete', array('id' => $cArticleId)),
            array(),
            array(),
            array(
                'HTTP_ORIGIN' => $origin,
                'HTTP_AUTHORIZATION' => "Bearer $token",
            )
        );
        $response = $this->client->getResponse();

        //assert
        $cArticle = CArticleQuery::create()->findOneById($cArticleId);

        $this->assertTrue($response->isOk());
        $this->assertNull($cArticle);

        $article = new CArticle();
        $article->fromArray($originCArticle);
        $article->save();
    }
}