<?php

namespace Widget\CategoryArticleBundle\Tests\Controller\API;

use Backend\BaseBundle\Tests\Fixture\BaseWebTestCase;
use Widget\CategoryArticleBundle\Model\CArticleQuery;

class CategoryArticleControllerTest extends BaseWebTestCase
{
    public function test_CArticleListAction_bad_category_id()
    {
        // arrange
        $id = "999999999";  // 沒有這個 category_id

        // act
        $this->client->request(
            'GET',
            $this->generateUrl('widget_categoryarticle_api_categoryarticle_carticlelist', array('id' => $id))
        );
        $response = $this->client->getResponse();

        // assert
        $this->assertTrue($response->isNotFound());

    }

    public function test_CArticleListAction_en_US()
    {
        // arrange
        $id = "99097114116";
        $expertJson = array(
            'pager' => array(
                'page' => 1,
                'pages' => 1,
                'rows' => 1,
            ),
            'data' => array(
                array(
                    'id' => '1',
                    'title' => '5566驚爆解散',
                    'brief' => '沒拿樂器的5月天 = 5566',
                    'created_at' => (new \DateTime('2016-12-01'))->format(DATE_ATOM),
                    'updated_at' => (new \DateTime('2016-12-31'))->format(DATE_ATOM),
                ),
            )
        );

        // act
        $this->client->request(
            'GET',
            $this->generateUrl('widget_categoryarticle_api_categoryarticle_carticlelist', array('id' => $id)),
            array(),
            array(),
            array(
                'HTTP_X-Locale' => 'en_US',
            )
        );
        $response = $this->client->getResponse();
        $responseArray = json_decode($response->getContent(), true);

        // assert
        $this->assertTrue($response->isOk());
        $this->assertArrayHasKey('pager', $responseArray);
        $this->assertArrayHasKey('data', $responseArray);
        $this->assertArrayHasKey('categories', $responseArray['data'][0]);
        $this->assertEquals($expertJson['data'][0]['id'], $responseArray['data'][0]['id']);
        $this->assertEquals($expertJson['data'][0]['title'], $responseArray['data'][0]['title']);
        $this->assertEquals($expertJson['data'][0]['brief'], $responseArray['data'][0]['brief']);
        $this->assertEquals($expertJson['data'][0]['created_at'], $responseArray['data'][0]['created_at']);
        $this->assertEquals($expertJson['data'][0]['updated_at'], $responseArray['data'][0]['updated_at']);
    }

    public function test_CArticleListAction_zh_TW()
    {
        // arrange
        $id = "99097114116";
        $expertJson = array(
            'pager' => array(
                'page' => 1,
                'pages' => 1,
                'rows' => 1,
            ),
            'data' => array(
                array(
                    'id' => '1',
                    'title' => '這是中文 Title',
                    'brief' => '這是中文 Brief',
                    'created_at' => (new \DateTime('2016-12-01'))->format(DATE_ATOM),
                    'updated_at' => (new \DateTime('2016-12-31'))->format(DATE_ATOM),
                ),
            )
        );

        $cArticle = CArticleQuery::create()
            ->findPk(1);
        $cArticle
            ->setLocale('zh_TW')
            ->setTitle($expertJson['data'][0]['title'])
            ->setBrief($expertJson['data'][0]['brief'])
            ->save();

        // act
        $this->client->request(
            'GET',
            $this->generateUrl('widget_categoryarticle_api_categoryarticle_carticlelist', array('id' => $id))
        );
        $response = $this->client->getResponse();
        $responseArray = json_decode($response->getContent(), true);

        // assert
        $this->assertTrue($response->isOk());
        $this->assertArrayHasKey('pager', $responseArray);
        $this->assertArrayHasKey('data', $responseArray);
        $this->assertArrayHasKey('categories', $responseArray['data'][0]);
        $this->assertEquals($expertJson['data'][0]['id'], $responseArray['data'][0]['id']);
        $this->assertEquals($expertJson['data'][0]['title'], $responseArray['data'][0]['title']);
        $this->assertEquals($expertJson['data'][0]['brief'], $responseArray['data'][0]['brief']);
        $this->assertEquals($expertJson['data'][0]['created_at'], $responseArray['data'][0]['created_at']);
        $this->assertEquals($expertJson['data'][0]['updated_at'], $responseArray['data'][0]['updated_at']);
    }

    public function test_getCArticleAction_bad_carticle_id()
    {
        // arrange
        $id = "999999";  // 沒有這個 carticle_id

        // act
        $this->client->request(
            'GET',
            $this->generateUrl('widget_categoryarticle_api_categoryarticle_getcarticle', array('id' => $id))
        );
        $response = $this->client->getResponse();

        // assert
        $this->assertTrue($response->isNotFound());
    }

    public function test_getCArticleAction_en_US()
    {
        // arrange
        $id = "1";
        $expertJson = array(
            'id' => '1',
            'title' => '5566驚爆解散',
            'content' => '才怪ob"_"ov',
            'brief' => '沒拿樂器的5月天 = 5566',
            'created_at' => (new \DateTime('2016-12-01'))->format(DATE_ATOM),
            'updated_at' => (new \DateTime('2016-12-31'))->format(DATE_ATOM),
        );

        // act
        $this->client->request(
            'GET',
            $this->generateUrl('widget_categoryarticle_api_categoryarticle_getcarticle', array('id' => $id)),
            array(),
            array(),
            array(
                'HTTP_X-Locale' => 'en_US',
            )
        );
        $response = $this->client->getResponse();
        $responseArray = json_decode($response->getContent(), true);

        // assert
        $this->assertTrue($response->isOk());
        $this->assertArrayHasKey('categories', $responseArray);
        $this->assertEquals($expertJson['id'], $responseArray['id']);
        $this->assertEquals($expertJson['title'], $responseArray['title']);
        $this->assertEquals($expertJson['brief'], $responseArray['brief']);
        $this->assertEquals($expertJson['created_at'], $responseArray['created_at']);
        $this->assertEquals($expertJson['updated_at'], $responseArray['updated_at']);
    }

    public function test_getCArticleAction_default()
    {
        // arrange
        $id = "1";
        $expertJson = array(
            'id' => '1',
            'title' => '中文 Title',
            'content' => '中文 Content',
            'brief' => '中文 Brief',
            'created_at' => (new \DateTime('2016-12-01'))->format(DATE_ATOM),
            'updated_at' => (new \DateTime('2016-12-31'))->format(DATE_ATOM),
        );
        $cArticle = CArticleQuery::create()
            ->findPk(1);
        $cArticle
            ->setLocale('zh_TW')
            ->setTitle($expertJson['title'])
            ->setBrief($expertJson['brief'])
            ->setContent($expertJson['content'])
            ->save();

        // act
        $this->client->request(
            'GET',
            $this->generateUrl('widget_categoryarticle_api_categoryarticle_getcarticle', array('id' => $id)),
            array(),
            array(),
            array(
                'HTTP_X-Locale' => 'zh_TW',
            )
        );
        $response = $this->client->getResponse();
        $responseArray = json_decode($response->getContent(), true);

        // assert
        $this->assertTrue($response->isOk());
        $this->assertArrayHasKey('categories', $responseArray);
        $this->assertEquals($expertJson['id'], $responseArray['id']);
        $this->assertEquals($expertJson['title'], $responseArray['title']);
        $this->assertEquals($expertJson['brief'], $responseArray['brief']);
        $this->assertEquals($expertJson['created_at'], $responseArray['created_at']);
        $this->assertEquals($expertJson['updated_at'], $responseArray['updated_at']);
    }
}