module.exports = {
  "list": {
    "id": {
      "label": "#",
      "type": "id",
      "sort": true,
      "search": true
      searchConfig:
        key: "id"
        type: "text"
        like: true
    },
    "title": {
      "label": "index.categoryarticle.title",
      "type": "text",
      "quick": true,
      "search": true
      searchConfig:
        key: "title"
        type: "text"
        like: true
    },
    "created_at": {
      "label": "index.categoryarticle.created_at",
      "type": "datetime-local",
      "sort": true
      defaultSorting: 'desc'
    },
    "updated_at": {
      "label": "index.categoryarticle.updated_at",
      "type": "datetime-local",
      "sort": true
    }
  },
  "extra": [
    {
      "name": "new"
      "label": "form.button.new"
      "roles": ["ROLE_CATEGORYARTICLE_WRITE"]
      "route": 'categoryarticle-new'
    }
  ],
  "action": [
    {
      "name": "edit"
      "label": "action.edit"
      "roles": ["ROLE_CATEGORYARTICLE_WRITE"]
      "route": 'categoryarticle-edit'
    }
    {
      "name": "delete"
      "label": "action.delete"
      "roles": ["ROLE_CATEGORYARTICLE_WRITE"]
      "component": require 'components/backendbase/partial/list/table/actions/delete.vue'
    }
  ]
}