<?php

namespace Widget\CategoryArticleBundle\Controller\BackendAPI;

use Backend\BaseBundle\Controller\BackendAPI\BaseBackendAPIController;
use Backend\BaseBundle\Form\Type\APIFormTypeItem;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Cache;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Method;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Security;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Widget\CategoryBundle\Model\CategoryQuery;

/**
 * @Route("/categoryarticles")
 * @Security("has_role_or_superadmin('ROLE_CATEGORYARTICLE')")
 */
class CategoryController extends BaseBackendAPIController
{
    /**
     * 欄位表單設定
     * 主要是USER送過來的欄位
     * @return APIFormTypeItem[]
     */
    protected function getFormConfig()
    {
        return array(
            new APIFormTypeItem('name'),
            new APIFormTypeItem('status'),
        );
    }

    /**
     * 查詢文章分類API
     * @Route("s/all")
     * @Method({"GET"})
     * @Security("has_role_or_superadmin('ROLE_PRODUCT_CATEGORY_READ')")
     */
    public function listAction(Request $request)
    {
        /** @var CategoryQuery $categoryQuery */
        $categoryQuery = CategoryQuery::create()
            ->joinWithI18n($request->attributes->get('_locale'))
            ->filterByStatus(true)
            ->filterByTreeLevel(0, \Criteria::GREATER_THAN)
            ->useCategoryThreadQuery()
            ->filterByThread('carticle')
            ->endUse()
            ->find()
        ;

        if(!$categoryQuery){
            return $this->createHttpExceptionResponse(Response::HTTP_BAD_REQUEST);
        }

        return $this->createJsonSerializeResponse($categoryQuery, array('list'));
    }
}