<?php

namespace Widget\CategoryArticleBundle\Controller\BackendAPI;

use Backend\BaseBundle\Controller\BackendAPI\BaseBackendAPIController;
use Backend\BaseBundle\Form\Type\APIFormTypeItem;
use Backend\BaseBundle\Propel\I18n;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Method;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Security;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\Validator\Constraints\NotBlank;
use Widget\ArticleBundle\Model\Article;
use Widget\ArticleBundle\Model\ArticlePeer;
use Widget\ArticleBundle\Model\ArticleQuery;
use Widget\CategoryArticleBundle\Model\CArticle;
use Widget\CategoryArticleBundle\Model\CArticlePeer;
use Widget\CategoryArticleBundle\Model\CArticleQuery;
use Widget\CategoryArticleBundle\Model\CategoryCArticle;
use Widget\CategoryArticleBundle\Model\CategoryCArticlePeer;
use Widget\CategoryArticleBundle\Model\CategoryCArticleQuery;
use Widget\CategoryBundle\Model\CategoryQuery;
use Widget\PhotoBundle\Form\Type\APIPhotoListType;

/**
 * @Route("/carticles")
 * @Security("has_role_or_superadmin('ROLE_CATEGORYARTICLE')")
 */
class CategoryArticleController extends BaseBackendAPIController
{

    /**
     * 欄位表單設定
     * 主要是USER送過來的欄位
     * @return APIFormTypeItem[]
     */
    protected function getFormConfig()
    {
        return array(
            (new APIFormTypeItem('title'))->setOptions(array(
                'required' => true,
                'constraints' => array(
                    new NotBlank(array(
                        'message' => 'error.carticle.title.missing_field',
                    )),
                )
            )),
            (new APIFormTypeItem('brief'))->setOptions(array(
                'required' => true,
                'constraints' => array(
                    new NotBlank(array(
                        'message' => 'error.carticle.brief.missing_field',
                    )),
                )
            )),
            (new APIFormTypeItem('content'))->setOptions(array(
                'required' => true,
                'constraints' => array(
                    new NotBlank(array(
                        'message' => 'error.carticle.content.missing_field',
                    )),
                )
            )),
            (new APIFormTypeItem('photos'))->setFieldType(new APIPhotoListType()),
        );
    }

    /**
     * 新增
     * @Route("s")
     * @Method({"POST"})
     * @Security("has_role_or_superadmin('ROLE_CATEGORYARTICLE_WRITE')")
     */
    public function createAction(Request $request)
    {
        $carticle = new CArticle();
        $carticle->setLocale($request->attributes->get('_locale'));
        // 抽離出來做（同樣）動作 參數： 物件、content
        return $this->doProcessForm($carticle, $request->getContent());
    }

    /**
     * 搜尋
     * @Route("s")
     * @Method({"GET"})
     * @Security("has_role_or_superadmin('ROLE_CATEGORYARTICLE_READ')")
     */
    public function searchAction(Request $request)
    {
        $query = CArticleQuery::create();
        $query->joinWithI18n($request->attributes->get('_defaultLocale'));
        return $this->doSearch($request->query->all(), $query->distinct(), CArticlePeer::class);
    }

    /**
     * 讀取
     * @Route("/{id}")
     * @Method({"GET"})
     * @Security("has_role_or_superadmin('ROLE_CATEGORYARTICLE_READ')")
     */
    public function readAction(Request $request, CArticle $cArticle)
    {
        $cArticle->setLocale($request->attributes->get('_locale'));
        return $this->createJsonSerializeResponse($cArticle, array('detail'));
    }

    /**
     * 更新
     * @Route("/{id}")
     * @Method({"PUT"})
     * @Security("has_role_or_superadmin('ROLE_CATEGORYARTICLE_WRITE')")
     */
    public function updateAction(Request $request, CArticle $cArticle)
    {
        $cArticle->setLocale($request->attributes->get('_locale'));
        return $this->doProcessForm($cArticle, $request->getContent());
    }

    /**
     * 刪除
     * @Route("/{id}")
     * @Method({"DELETE"})
     * @Security("has_role_or_superadmin('ROLE_CATEGORYARTICLE_WRITE')")
     */
    public function deleteAction(CArticle $CArticle)
    {
        $this->deleteObject($CArticle);
        return $this->createJsonResponse();
    }

    /**
     * 批次管理
     * @Route("s")
     * @Method({"PUT"})
     * @Security("has_role_or_superadmin('ROLE_ARTICLE_WRITE')")
     */
    public function batchAction(Request $request)
    {
        return parent::batchAction($request);
    }

    /**
     * 批次切換狀態處理
     * @param $ids
     * @param $con
     * @param $column
     */
    protected function batchSwitch($ids, $column, \PropelPDO $con)
    {
        $articles = CArticleQuery::create()->findPks($ids, $con);
        foreach ($articles as $article) {
            $value = $article->getByName($column, \BasePeer::TYPE_FIELDNAME);
            $article->setByName($column, !$value, \BasePeer::TYPE_FIELDNAME);
            $article->save($con);
        }
    }

    /**
     * 批次切換狀態處理
     * @param $ids
     * @param $con
     * @param $column
     */
    protected function batchDelete($ids, \PropelPDO $con)
    {
        CArticleQuery::create()->findPks($ids, $con)->delete($con);
    }

    /**
     * 設定分類文章 分類分類 關聯
     * @Route("/{id}/categoryarticle")
     * @Method({"POST"})
     */
    public function relateToCategoryAction(Request $request, CArticle $cArticle)
    {
        $requestParams = json_decode($request->getContent(), true);

        if (!isset($requestParams['categories']) || count($requestParams['categories']) == 0) {
            $emptyCategory = CategoryQuery::create()->findPks(array());
            $cArticle->setCategories($emptyCategory)->save();
            return $this->createJsonSerializeResponse($cArticle, array('list'));
        }

        $categoryIds = array();
        foreach ($requestParams['categories'] as $category){
            $categoryIds[] = $category['id'];
        }
        $categories = CategoryQuery::create()->findPks($categoryIds);
        $cArticle->setCategories($categories)->save();
        return $this->createJsonSerializeResponse($cArticle, array('list'));
    }

}