<?php

namespace Widget\CategoryArticleBundle\Controller\API;

use Backend\BaseBundle\Controller\API\BaseController;
use Backend\BaseBundle\Model\Site;
use Backend\BaseBundle\Propel\I18n;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Method;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\ParamConverter;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Widget\CategoryArticleBundle\Model\CArticle;
use Widget\CategoryArticleBundle\Model\CArticleQuery;
use Widget\CategoryBundle\Model\Category;

/**
 * @Route("/carticles")
 */
class CategoryArticleController extends BaseController
{
    /**
     * @Route("/{id}")
     * @Method("GET")
     */
    public function CArticleListAction(Request $request, Category $category)
    {
        $page = $request->query->getInt('page', 1);
        $query = CArticleQuery::create()
            ->joinWithI18n($request->attributes->get('_locale'));

        /** @var \PropelModelPager $pager */
        $pager = $query
            ->filterByCategory($category)
            ->paginate($page, 10);

        return $this->createJsonSerializeResponse($pager, array('list'));
    }

    /**
     * @Route("/detail/{id}")
     * @Method("GET")
     */
    public function getCArticleAction(Request $request, CArticle $carticle)
    {
        if(!$carticle){
            return $this->createHttpExceptionResponse(Response::HTTP_NOT_FOUND);
        }
        $carticle->setLocale($request->attributes->get('_locale'));
        return $this->createJsonSerializeResponse($carticle, array('detail'));
    }
}
