<?php
namespace Widget\BannerBundle\Tests\InitDatabase;

use Backend\BaseBundle\Event\TestInitEvent;
use JMS\DiExtraBundle\Annotation\Observe;
use JMS\DiExtraBundle\Annotation\Inject;
use JMS\DiExtraBundle\Annotation\InjectParams;
use JMS\DiExtraBundle\Annotation\Service;
use Symfony\Component\HttpFoundation\File\File;
use Widget\BannerBundle\Model\Banner;
use Widget\BannerBundle\Model\BannerCategory;
use Widget\BannerBundle\Model\BannerCategoryQuery;
use Widget\PhotoBundle\File\PhotoUploadFile;
use Widget\PhotoBundle\Image\PhotoConfigFinder;
use Widget\PhotoBundle\Image\Resizer;

/**
 * @Service
 */
class InitBannerContent
{

    /** @var  \Faker\Generator */
    protected $faker;

    /** @var  Resizer */
    protected $resizer;

    /** @var  PhotoConfigFinder */
    protected $configFinder;

    /**
     * @InjectParams({
     *     "faker" = @Inject("faker.generator", required = false),
     * })
     */
    public function injectFaker(\Faker\Generator $faker)
    {
        $this->faker = $faker;
    }

    /**
     * @InjectParams({
     *     "resizer" = @Inject("widget_photo.image.resizer"),
     * })
     */
    public function injectResizer(Resizer $resizer)
    {
        $this->resizer = $resizer;
    }

    /**
     * @InjectParams({
     *     "configFinder" = @Inject("widget.photo_bundle.config_finder"),
     * })
     */
    public function injectConfigFinder(PhotoConfigFinder $configFinder)
    {
        $this->configFinder = $configFinder;
    }

    /**
     * @Observe(TestInitEvent::EVENT_TEST_INIT, priority = 90)
     */
    public function onInit(TestInitEvent $event)
    {
        $bannerCategory = BannerCategoryQuery::create()->findOneByName('banner1');
        $event->getOutput()->writeln("<info>Create Banner</info>");
        $this->appendBanner($bannerCategory);
        $event->getOutput()->writeln("<comment>5</comment> <info>Banner created</info>");
    }

    protected function appendBanner(BannerCategory $bannerCategory)
    {
        $banner = new Banner();
        $banner
            ->setName('content1')
            ->setUrl($this->faker->url)
            ->setSort(5)
            ->setBannerCategory($bannerCategory)
        ;
        $this->attachPhoto($banner);
        $banner->save();

        $banner = new Banner();
        $banner
            ->setName('content2')
            ->setUrl($this->faker->url)
            ->setStartAt(time())
            ->setSort(4)
            ->setBannerCategory($bannerCategory)
        ;
        $this->attachPhoto($banner);
        $banner->save();

        $banner = new Banner();
        $banner
            ->setName('content3')
            ->setUrl($this->faker->url)
            ->setStopAt(time())
            ->setSort(3)
            ->setBannerCategory($bannerCategory)
        ;
        $this->attachPhoto($banner);
        $banner->save();

        $banner = new Banner();
        $banner
            ->setName('content4')
            ->setUrl($this->faker->url)
            ->setStatus(false)
            ->setSort(2)
            ->setBannerCategory($bannerCategory)
        ;
        $this->attachPhoto($banner);
        $banner->save();

        $banner = new Banner();
        $banner
            ->setName('content5')
            ->setUrl($this->faker->url)
            ->setSort(1)
            ->setBannerCategory($bannerCategory)
        ;
        $this->attachPhoto($banner);
        $banner->save();
    }

    protected function attachPhoto(Banner $banner)
    {
        $photoFile = new File($this->fakePhoto(1024, 768));

        $uploadPhoto = PhotoUploadFile::createFromUploadFile(
            $photoFile,
            $this->resizer,
            $this->configFinder->findConfig('banner1')
        );
        $photo = $uploadPhoto->makePhoto();
        $photo->save();
        $banner->setPhotos(array($photo));
    }

    protected function fakePhoto($width, $height)
    {
        //return $this->faker->image(sys_get_temp_dir(), $width, $height);
        return __DIR__.'/../Fixture/sports.jpg';
    }
}
