<?php

namespace Widget\BannerBundle\Tests\Controller\BackendAPI;

use Backend\BaseBundle\Model\SiteUserQuery;
use Backend\BaseBundle\Tests\Fixture\BackendWebTestCase;
use Widget\BannerBundle\Model\Banner;
use Widget\BannerBundle\Model\BannerCategoryQuery;
use Widget\BannerBundle\Model\BannerQuery;

class BannerControllerTest extends BackendWebTestCase
{
    public function test_createAction()
    {
        //arrange
        $loginName = 'admin';
        $origin = 'http://localhost';
        $token = $this->createToken(SiteUserQuery::create()->findOneByLoginName($loginName), $origin);
        $bannerCategory = BannerCategoryQuery::create()->findOneByName('banner1');
        $params = array(
            'banner_id' => $bannerCategory->getId(),
            'name' => 'banner_name_create',
            'url' => 'http://www.google.com.tw',
            'sort' => 123,
            'status' => true,
            'start_at' => '2014-01-01 00:00:00',
            'stop_at' => '2020-12-31 00:00:00',
            'photos' => []
        );

        //act
        $this->client->request(
            'POST',
            $this->generateUrl('widget_banner_backendapi_banner_create'),
            array(),
            array(),
            array(
                'HTTP_ORIGIN' => $origin,
                'HTTP_AUTHORIZATION' => "Bearer $token",
            ),
            json_encode($params)
        );
        $response = $this->client->getResponse();
        $banner = BannerQuery::create()->findOneByName($params['name']);

        //assert
        $this->assertTrue($response->isOk());
        $this->assertEquals($params['name'], $banner->getName());
        $this->assertEquals($params['url'], $banner->getUrl());

        $banner->delete();
    }

    public function test_searchAction()
    {
        //arrange
        $loginName = 'admin';
        $origin = 'http://localhost';
        $token = $this->createToken(SiteUserQuery::create()->findOneByLoginName($loginName), $origin);
        $searchParams = array(
            'page' => 1,
            'sort' => array(
                'created_at' => 'asc'
            ),
            'search' => array(
                'name' => '%content%',
            ),
        );

        //act
        $this->client->request(
            'GET',
            $this->generateUrl('widget_banner_backendapi_banner_search', $searchParams),
            array(),
            array(),
            array(
                'HTTP_ORIGIN' => $origin,
                'HTTP_AUTHORIZATION' => "Bearer $token",
            )
        );
        $response = $this->client->getResponse();
        $responseArray = json_decode($response->getContent(), true);

        // assert
        $this->assertTrue($response->isOk());
        $this->assertArrayHasKey('pager', $responseArray);
        $this->assertArrayHasKey('page', $responseArray['pager']);
        $this->assertArrayHasKey('pages', $responseArray['pager']);
        $this->assertArrayHasKey('rows', $responseArray['pager']);

        $this->assertArrayHasKey('data', $responseArray);
        $this->assertArrayHasKey('id', $responseArray['data'][0]);
        $this->assertArrayHasKey('name', $responseArray['data'][0]);
        $this->assertArrayHasKey('url', $responseArray['data'][0]);
        $this->assertArrayHasKey('photos', $responseArray['data'][0]);
        $this->assertArrayHasKey('created_at', $responseArray['data'][0]);
        $this->assertArrayHasKey('updated_at', $responseArray['data'][0]);
    }

    public function test_readAction()
    {
        //arrange
        $loginName = 'admin';
        $origin = 'http://localhost';
        $token = $this->createToken(SiteUserQuery::create()->findOneByLoginName($loginName), $origin);
        $bannerCategory = BannerCategoryQuery::create()->findOneByName('banner1');
        $params = array(
            'BannerId' => $bannerCategory->getId(),
            'Name' => 'banner_name_read',
            'Url' => 'http://www.google.com.tw',
            'Sort' => 123,
            'Status' => true,
            'StartAt' => '2014-01-01 00:00:00',
            'StopAt' => '2020-12-31 00:00:00',
        );
        $banner = new Banner();
        $banner->fromArray($params);
        $banner->save();

        //act
        $this->client->request(
            'GET',
            $this->generateUrl('widget_banner_backendapi_banner_read', array('id' => $banner->getId())),
            array(),
            array(),
            array(
                'HTTP_ORIGIN' => $origin,
                'HTTP_AUTHORIZATION' => "Bearer $token",
            )
        );
        $response = $this->client->getResponse();
        $responseArray = json_decode($response->getContent(), true);

        //assert
        $this->assertTrue($response->isOk());
        $this->assertEquals($params['Name'], $responseArray['name']);
        $this->assertEquals($params['Url'], $responseArray['url']);

        $banner->delete();
    }

    public function test_updateAction()
    {
        //arrange
        $loginName = 'admin';
        $origin = 'http://localhost';
        $token = $this->createToken(SiteUserQuery::create()->findOneByLoginName($loginName), $origin);
        $bannerCategory = BannerCategoryQuery::create()->findOneByName('banner1');
        $params = array(
            'BannerId' => $bannerCategory->getId(),
            'Name' => 'banner_name_read',
            'Url' => 'http://www.google.com.tw',
            'Sort' => 123,
            'Status' => true,
            'StartAt' => '2014-01-01 00:00:00',
            'StopAt' => '2020-12-31 00:00:00',
        );
        $banner = new Banner();
        $banner->fromArray($params);
        $banner->save();

        $updateParams = array(
            'name' => 'banner_name_update',
            'url' => 'https://tw.yahoo.com'
        );

        //act
        $this->client->request(
            'PUT',
            $this->generateUrl('widget_banner_backendapi_banner_update', array('id' => $banner->getId())),
            array(),
            array(),
            array(
                'HTTP_ORIGIN' => $origin,
                'HTTP_AUTHORIZATION' => "Bearer $token",
            ),
            json_encode($updateParams)
        );
        $response = $this->client->getResponse();
        $responseArray = json_decode($response->getContent(), true);

        //assert
        $this->assertTrue($response->isOk());
        $this->assertEquals($updateParams['name'], $responseArray['name']);
        $this->assertEquals($updateParams['url'], $responseArray['url']);

        $banner->delete();
    }

    public function test_deleteAction()
    {
        //arrange
        $loginName = 'admin';
        $origin = 'http://localhost';
        $token = $this->createToken(SiteUserQuery::create()->findOneByLoginName($loginName), $origin);
        $bannerCategory = BannerCategoryQuery::create()->findOneByName('banner1');
        $params = array(
            'BannerId' => $bannerCategory->getId(),
            'Name' => 'banner_name_delete',
            'Url' => 'http://www.google.com.tw',
            'Sort' => 123,
            'Status' => true,
            'StartAt' => '2014-01-01 00:00:00',
            'StopAt' => '2020-12-31 00:00:00',
        );
        $banner = new Banner();
        $banner->fromArray($params);
        $banner->save();

        //act
        $this->client->request(
            'DELETE',
            $this->generateUrl('widget_banner_backendapi_banner_delete', array('id' => $banner->getId())),
            array(),
            array(),
            array(
                'HTTP_ORIGIN' => $origin,
                'HTTP_AUTHORIZATION' => "Bearer $token",
            )
        );
        $response = $this->client->getResponse();

        //assert
        $bannerQuery = BannerQuery::create()->findOneByName('banner_name_delete');
        $this->assertTrue($response->isOk());
        $this->assertNull($bannerQuery);

    }
}