<?php

namespace Widget\BannerBundle\Tests\Controller\BackendAPI;

use Backend\BaseBundle\Model\SiteUserQuery;
use Backend\BaseBundle\Tests\Fixture\BackendWebTestCase;
use Widget\BannerBundle\Model\Banner;
use Widget\BannerBundle\Model\BannerCategory;
use Widget\BannerBundle\Model\BannerCategoryQuery;
use Widget\BannerBundle\Model\BannerQuery;
use Widget\PhotoBundle\Model\PhotoConfigQuery;

class BannerCategoryControllerTest extends BackendWebTestCase
{
    /**
     * @throws \Exception
     * @throws \PropelException
     */
    public function test_createAction()
    {
        //arrange
        $loginName = 'admin';
        $origin = 'http://localhost';
        $token = $this->createToken(SiteUserQuery::create()->findOneByLoginName($loginName), $origin);
        $photoConfig = PhotoConfigQuery::create()->findOneByName('banner1');
        $params = array(
            'name' => 'banner_code',
            'title' => 'banner_title',
            'photo_config_id' => $photoConfig->getId(),
        );

        //act
        $this->client->request(
            'POST',
            $this->generateUrl('widget_banner_backendapi_bannercategory_create'),
            array(),
            array(),
            array(
                'HTTP_ORIGIN' => $origin,
                'HTTP_AUTHORIZATION' => "Bearer $token",
            ),
            json_encode($params)
        );
        $response = $this->client->getResponse();

        //assert
        $bannerCategory = BannerCategoryQuery::create()->findOneByName('banner_code');
        $this->assertTrue($response->isOk());
        $this->assertEquals($params['name'], $bannerCategory->getName());
        $this->assertEquals($params['title'], $bannerCategory->getTitle());
        $this->assertEquals($params['photo_config_id'], $bannerCategory->getPhotoConfigId());

        $bannerCategory->delete();
    }

    public function test_searchAction()
    {
        //arrange
        $loginName = 'admin';
        $origin = 'http://localhost';
        $token = $this->createToken(SiteUserQuery::create()->findOneByLoginName($loginName), $origin);
        $bannerCategory = BannerCategoryQuery::create()->findOneByName('banner1');
        $searchParams = array(
            'page' => 1,
            'sort' => array(
                'id' => 'asc'
            ),
            'search' => array(
                'id' => '%',
            ),
        );
        //act
        $this->client->request(
            'GET',
            $this->generateUrl('widget_banner_backendapi_bannercategory_search', array('id' => $bannerCategory->getId())),
            array(),
            array(),
            array(
                'HTTP_ORIGIN' => $origin,
                'HTTP_AUTHORIZATION' => "Bearer $token",
            ),
            json_encode($searchParams)
        );
        $response = $this->client->getResponse();
        $responseArray = json_decode($response->getContent(), true);

        // assert
        $this->assertTrue($response->isOk());
        $this->assertArrayHasKey('pager', $responseArray);
        $this->assertArrayHasKey('page', $responseArray['pager']);
        $this->assertArrayHasKey('pages', $responseArray['pager']);
        $this->assertArrayHasKey('rows', $responseArray['pager']);

        $this->assertArrayHasKey('data', $responseArray);
    }

    public function test_readAction()
    {
        //arrange
        $loginName = 'admin';
        $origin = 'http://localhost';
        $token = $this->createToken(SiteUserQuery::create()->findOneByLoginName($loginName), $origin);
        $bannerCategory = BannerCategoryQuery::create()->findOneByName('banner1');

        //act
        $this->client->request(
            'GET',
            $this->generateUrl('widget_banner_backendapi_bannercategory_read', array('id' => $bannerCategory->getId())),
            array(),
            array(),
            array(
                'HTTP_ORIGIN' => $origin,
                'HTTP_AUTHORIZATION' => "Bearer $token",
            )
        );
        $response = $this->client->getResponse();
        $responseArray = json_decode($response->getContent(), true);

        // assert
        $this->assertTrue($response->isOk());
        $this->assertEquals($bannerCategory->getId(), $responseArray['id']);
        $this->assertEquals($bannerCategory->getPhotoConfigId(), $responseArray['photo_config']['id']);
    }

    public function test_updateAction()
    {
        //arrange
        $loginName = 'admin';
        $origin = 'http://localhost';
        $token = $this->createToken(SiteUserQuery::create()->findOneByLoginName($loginName), $origin);
        $bannerCategory = BannerCategoryQuery::create()->findOneByName('banner1');
        $originPhotoConfig  = PhotoConfigQuery::create()->filterByName('banner1')->findOne();
        $photoConfig = PhotoConfigQuery::create()->filterByName('banner2')->findOne();
        $params = array(
            'photo_config_id' => $photoConfig->getId(),
        );

        //act
        $this->client->request(
            'PUT',
            $this->generateUrl('widget_banner_backendapi_bannercategory_update', array('id' => $bannerCategory->getId())),
            array(),
            array(),
            array(
                'HTTP_ORIGIN' => $origin,
                'HTTP_AUTHORIZATION' => "Bearer $token",
            ),
            json_encode($params)
        );
        $response = $this->client->getResponse();
        $responseArray = json_decode($response->getContent(), true);

        // assert
        $bannerCategory->reload(true);
        $this->assertTrue($response->isOk());
        $this->assertEquals($photoConfig->getId(), $responseArray['photo_config']['id']);

        // reset
        $bannerCategory->setPhotoConfig($originPhotoConfig);
        $bannerCategory->save();
    }

    public function test_deleteAction()
    {
        //arrange
        $loginName = 'admin';
        $origin = 'http://localhost';
        $token = $this->createToken(SiteUserQuery::create()->findOneByLoginName($loginName), $origin);
        $bannerCategory = BannerCategoryQuery::create()->findOneByName('banner1');
        $id = '54875487';
        $bannerClone = new BannerCategory();
        $bannerClone->fromArray($bannerCategory->toArray());
        $bannerClone->setId($id);
        $bannerClone->save();


        //act
        $this->client->request(
            'DELETE',
            $this->generateUrl('widget_banner_backendapi_bannercategory_delete', array('id' => $id)),
            array(),
            array(),
            array(
                'HTTP_ORIGIN' => $origin,
                'HTTP_AUTHORIZATION' => "Bearer $token",
            )
        );
        $response = $this->client->getResponse();

        // assert
        $bannerCategoryQuery = BannerCategoryQuery::create()->findPk($id);
        $this->assertTrue($response->isOk());
        $this->assertNull($bannerCategoryQuery);

    }

}