<?php
namespace Widget\BannerBundle\Tests\API;

use Backend\BaseBundle\Tests\Fixture\BaseWebTestCase;
use Widget\BannerBundle\Model\BannerCategoryQuery;

class BannerControllerTest extends BaseWebTestCase
{
    /*
     * 無效ID
     */
    public function test_getBannerAction_invaild_id()
    {
        //arrange
        $name = 'bad_banner';

        //act
        $this->client->request('GET', $this->generateUrl('widget_banner_api_banner_getbanner', array('name' => $name)));
        $response = $this->client->getResponse();

        //assert
        $this->assertTrue($response->isNotFound());
    }

    /*
     * 有效ID
     */
    public function test_getBannerAction_vaild_id()
    {
        //arrange
        $name = 'banner1';

        //act
        $this->client->request('GET', $this->generateUrl('widget_banner_api_banner_getbanner', array('name' => $name)));
        $response = $this->client->getResponse();

        //assert
        $this->assertTrue($response->isOk());
    }

    /*
     * 找出來的數量應該是 3 筆
     */
    public function test_getBannerAction_count_is_3()
    {
        //arrange
        $name = 'banner1';

        //act
        $this->client->request('GET', $this->generateUrl('widget_banner_api_banner_getbanner', array('name' => $name)));
        $response = $this->client->getResponse();
        $result = json_decode($response->getContent(), true);

        //assert
        $this->assertEquals(3, count($result));
        $this->assertArrayHasKey('id', $result[0]);
        $this->assertArrayHasKey('name', $result[0]);
        $this->assertArrayHasKey('url', $result[0]);
        $this->assertArrayHasKey('target', $result[0]);
        $this->assertArrayHasKey('photos', $result[0]);
    }

    /*
     * 檢查排序對不對
     */
    public function test_getBannerAction_sort_is_correct()
    {
        //arrange
        $bannerCategory = BannerCategoryQuery::create()->findOneByName('banner1');
        
        $ids = array();
        foreach($bannerCategory->getBanners() as $bannerContent){
            $ids[$bannerContent->getName()] = $bannerContent->getId();
        }

        //act
        $this->client->request('GET', $this->generateUrl('widget_banner_api_banner_getbanner', array('name' => $bannerCategory->getName())));
        $response = $this->client->getResponse();
        $result = json_decode($response->getContent(), true);

        //assert
        $this->assertEquals(array(
            $ids['content1'],
            $ids['content2'],
            $ids['content5'],
         ), array_column($result, 'id'));
    }
}