module.exports =
{
  "list": {
    "id": {
      "label": "#",
      "type": "id",
      "sort": true
    },
    "name": {
      "label": "index.category.name",
      "type": "text",
      "sort": true,
      "quick": true,
      "search": true
      searchConfig:
        key: "name"
        type: "text"
        like: true
    },
    "title": {
      "label": "index.category.title",
      "type": "text",
      "sort": true,
      "quick": true,
      "search": true
      searchConfig:
        key: "title"
        type: "text"
        like: true
    },
    "photo_config.name":{
      "label": "index.category.photo_config",
      "type": "text",
      "sort": true
    },
    "created_at": {
      "label": "index.category.created_at",
      "type": "datetime-local",
      "sort": true
      defaultSorting: 'desc'
    },
    "updated_at": {
      "label": "index.category.updated_at",
      "type": "datetime-local",
      "sort": true
    }
  },
  "extra": [
    {
      "name": "new"
      "label": "form.button.new"
      "roles": ["ROLE_BANNER_WRITE"]
      "route": 'bannercategory-new'
    }
  ],
  "action": [
    {
      "name": "edit",
      "label": "action.edit",
      "roles": ["ROLE_BANNER_WRITE"]
      "route": 'bannercategory-edit'
    },
    {
      "name": "delete",
      "label": "action.delete",
      "roles": ["ROLE_BANNER_WRITE"]
      "component": require 'components/backendbase/partial/list/table/actions/delete.vue'
    }
  ]
}