module.exports =
{
  "list": {
    "id": {
      "label": "#",
      "type": "id",
      "sort": true
    },
    "name": {
      "label": "index.banner.name",
      "type": "text",
      "sort": true,
      "quick": true,
      "search": true
      searchConfig:
        key: "name"
        type: "text"
        like: true
    },
    "banner_category.title": {
      "label": "index.banner.banner_category",
      "type": "text"
    },
    "sort": {
      "label": "index.banner.sort",
      "type": "text",
      "sort": true
    },
    "status": {
      "label": "index.banner.status",
      "type": "checkbox"
      batch: true
      config:
        value:
          true: 1
          false: 0
      batchSetting: [
        { label: 'index.banner.enable', value: true }
        { label: 'index.banner.disable', value: false }
      ]
    },
    "start_at":{
      "label": "index.banner.start_at",
      "type": "date",
      "sort": true
    },
    "stop_at":{
      "label": "index.banner.stop_at",
      "type": "date",
      "sort": true
    },
    "photos":{
      "label": "index.banner.photos",
      "type": "image"
    },
    "created_at": {
      "label": "index.banner.created_at",
      "type": "datetime-local",
      "sort": true
      defaultSorting: 'desc'
    },
    "updated_at": {
      "label": "index.banner.updated_at",
      "type": "datetime-local",
      "sort": true
    }
  },
  "extra": [
    {
      "name": "new"
      "label": "form.button.new"
      "roles": ["ROLE_BANNER_WRITE"]
      "route": 'banner-new'
    }
    {
      "name": "quick_search",
      "label": "action.quick",
      "roles": ["ROLE_ORDER_WRITE"]
      component: require 'components/backendbase/partial/list/extra/quicksearch.vue'
      config:
        key: 'banner_id'
        getStatus: 'banner.bannerCategory'
        apiName: 'banner'
        status: [
          { title: 'index.banner.quick_search.all', label: 'index.banner.quick_search.all', value: 'all' }
        ]
    }
  ],
  "action": [
    {
      "name": "edit",
      "label": "action.edit",
      "roles": ["ROLE_BANNER_WRITE"]
      "route": 'banner-edit'
    },
    {
      "name": "delete",
      "label": "action.delete",
      "roles": ["ROLE_BANNER_WRITE"]
      "component": require 'components/backendbase/partial/list/table/actions/delete.vue'
    }
  ]
}