<?php
namespace Widget\BannerBundle\Controller\API;


use Backend\BaseBundle\Controller\API\BaseController;
use Backend\BaseBundle\Model\Site;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Cache;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Method;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Widget\BannerBundle\Model\BannerCategoryQuery;
use Widget\BannerBundle\Model\BannerQuery;

/**
 * @Route("/banner")
 */
class BannerController extends BaseController
{
    /**
     * 取得版位API
     * @Route("/{name}")
     * @Method({"GET"})
     */
    public function getBannerAction($name)
    {
        if(!($bannerCategory = BannerCategoryQuery::create()->filterByName($name)->findOne())) {
            throw $this->createNotFoundException();
        }

        $query = BannerQuery::create()
            ->filterByStatus(true)
            ->orderBySort(\Criteria::DESC)
            ->filterByStartAt(time(), \Criteria::LESS_THAN)
            ->_or()
            ->filterByStartAt(null, \Criteria::ISNULL)
            ->filterByStopAt(time(), \Criteria::GREATER_THAN)
            ->_or()
            ->filterByStopAt(null, \Criteria::ISNULL)
            ;

        $banner = $bannerCategory->getBanners($query);
        return $this->createJsonSerializeResponse($banner, array('list'));
    }

}