<?php
namespace Widget\BannerBundle\Tests\InitDatabase;

use Backend\BaseBundle\Event\TestInitEvent;
use Backend\BaseBundle\Model;
use JMS\DiExtraBundle\Annotation\Observe;
use JMS\DiExtraBundle\Annotation\Inject;
use JMS\DiExtraBundle\Annotation\InjectParams;
use JMS\DiExtraBundle\Annotation\Service;
use Symfony\Component\HttpFoundation\File\File;
use Widget\BannerBundle\Model\Banner;
use Widget\BannerBundle\Model\BannerContent;
use Widget\BannerBundle\Model\BannerQuery;
use Widget\CategoryBundle\Model\Category;
use Widget\CategoryBundle\Model\CategoryQuery;
use Widget\PhotoBundle\File\PhotoUploadFile;
use Widget\PhotoBundle\Image\PhotoConfigFinder;
use Widget\PhotoBundle\Image\Resizer;
use Widget\ProductBundle\Model\Product;

/**
 * @Service
 */
class InitBannerContent
{

    /** @var  \Faker\Generator */
    protected $faker;

    /** @var  Resizer */
    protected $resizer;

    /** @var  PhotoConfigFinder */
    protected $configFinder;

    /**
     * @InjectParams({
     *     "faker" = @Inject("faker.generator", required = false),
     * })
     */
    public function injectFaker(\Faker\Generator $faker)
    {
        $this->faker = $faker;
    }

    /**
     * @InjectParams({
     *     "resizer" = @Inject("widget_photo.image.resizer"),
     * })
     */
    public function injectResizer(Resizer $resizer)
    {
        $this->resizer = $resizer;
    }

    /**
     * @InjectParams({
     *     "configFinder" = @Inject("widget.photo_bundle.config_finder"),
     * })
     */
    public function injectConfigFinder(PhotoConfigFinder $configFinder)
    {
        $this->configFinder = $configFinder;
    }

    /**
     * @Observe(TestInitEvent::EVENT_TEST_INIT, priority = 90)
     */
    public function onInit(TestInitEvent $event)
    {
        $banner = BannerQuery::create()->findOneByName('banner1');
        $event->getOutput()->writeln("<info>Create BannerContent</info>");
        $this->appendBannerContent($banner);
        $event->getOutput()->writeln("<comment>5</comment> <info>BannerContens created</info>");
    }

    protected function appendBannerContent(Banner $banner)
    {
        $bannerContent = new BannerContent();
        $bannerContent
            ->setSiteId($banner->getSiteId())
            ->setName('content1')
            ->setUrl($this->faker->url)
            ->setSort(5)
            ->setBanner($banner)
        ;
        $this->attachPhoto($bannerContent);
        $bannerContent->save();

        $bannerContent = new BannerContent();
        $bannerContent
            ->setSiteId($banner->getSiteId())
            ->setName('content2')
            ->setUrl($this->faker->url)
            ->setStartAt(time())
            ->setSort(4)
            ->setBanner($banner)
        ;
        $this->attachPhoto($bannerContent);
        $bannerContent->save();

        $bannerContent = new BannerContent();
        $bannerContent
            ->setSiteId($banner->getSiteId())
            ->setName('content3')
            ->setUrl($this->faker->url)
            ->setStopAt(time())
            ->setSort(3)
            ->setBanner($banner)
        ;
        $this->attachPhoto($bannerContent);
        $bannerContent->save();

        $bannerContent = new BannerContent();
        $bannerContent
            ->setSiteId($banner->getSiteId())
            ->setName('content4')
            ->setUrl($this->faker->url)
            ->setStatus(false)
            ->setSort(2)
            ->setBanner($banner)
        ;
        $this->attachPhoto($bannerContent);
        $bannerContent->save();

        $bannerContent = new BannerContent();
        $bannerContent
            ->setSiteId($banner->getSiteId())
            ->setName('content5')
            ->setUrl($this->faker->url)
            ->setSort(1)
            ->setBanner($banner)
        ;
        $this->attachPhoto($bannerContent);
        $bannerContent->save();
    }

    protected function attachPhoto(BannerContent $bannerContent)
    {
        $photoFile = new File($this->fakePhoto(1024, 768));

        $uploadPhoto = PhotoUploadFile::createFromUploadFile(
            $photoFile,
            $this->resizer,
            $this->configFinder->findConfig($bannerContent->getSiteId(), 'banner1')
        );
        $photo = $uploadPhoto->makePhoto();
        $photo->setSiteId(12345);
        $photo->save();
        $bannerContent->setPhotos(array($photo));
    }

    protected function fakePhoto($width, $height)
    {
        //return $this->faker->image(sys_get_temp_dir(), $width, $height);
        return __DIR__.'/../Fixture/sports.jpg';
    }
}
