<?php
namespace Widget\BannerBundle\Tests\API;

use Backend\BaseBundle\Tests\Fixture\BaseWebTestCase;
use Widget\BannerBundle\Model\BannerQuery;

class BannerControllerTest extends BaseWebTestCase
{
    /*
     * 無效ID
     */
    public function test_getBannerContentAction_invaild_id()
    {
        //arrange
        $slug = 'dgfactor';
        $name = 'bad_banner';

        //act
        $this->client->request('GET', $this->generateUrl('widget_banner_api_banner_getbannercontent', array('slug' => $slug, 'name' => $name)));
        $response = $this->client->getResponse();

        //assert
        $this->assertTrue($response->isNotFound());
    }

    /*
     * 有效ID
     */
    public function test_getBannerContentAction_vaild_id()
    {
        //arrange
        $slug = 'dgfactor';
        $name = 'banner1';

        //act
        $this->client->request('GET', $this->generateUrl('widget_banner_api_banner_getbannercontent', array('slug' => $slug, 'name' => $name)));
        $response = $this->client->getResponse();

        //assert
        $this->assertTrue($response->isOk());
    }

    /*
     * 找出來的數量應該是 3 筆
     */
    public function test_getBannerContentAction_count_is_3()
    {
        //arrange
        $slug = 'dgfactor';
        $name = 'banner1';

        //act
        $this->client->request('GET', $this->generateUrl('widget_banner_api_banner_getbannercontent', array('slug' => $slug, 'name' => $name)));
        $response = $this->client->getResponse();
        $result = json_decode($response->getContent(), true);

        //assert
        $this->assertEquals(3, count($result));
    }

    /*
     * 檢查排序對不對
     */
    public function test_getBannerContentAction_sort_is_correct()
    {
        //arrange
        $slug = 'dgfactor';
        $banner = BannerQuery::create()->findOneByName('banner1');
        
        $ids = array();
        foreach($banner->getBannerContents() as $bannerContent){
            $ids[$bannerContent->getName()] = $bannerContent->getId();
        }

        //act
        $this->client->request('GET', $this->generateUrl('widget_banner_api_banner_getbannercontent', array('slug' => $slug, 'name' => $banner->getName())));
        $response = $this->client->getResponse();
        $result = json_decode($response->getContent(), true);

        //assert
        $this->assertEquals(array(
            $ids['content1'],
            $ids['content2'],
            $ids['content5'],
         ), array_column($result, 'id'));
    }
}