<?php
namespace Widget\BannerBundle\EventListener\ControllerConfig;

use Backend\BaseBundle\Event\Controller\ConfigEvent;
use Backend\BaseBundle\Event\Controller\MenuEvent;
use Backend\BaseBundle\Event\Controller\TypeRolesEvent;
use Backend\BaseBundle\Form\Type\RelationType;
use Backend\BaseBundle\Form\Type\SubmitBackType;
use JMS\DiExtraBundle\Annotation\InjectParams;
use JMS\DiExtraBundle\Annotation\Observe;
use JMS\DiExtraBundle\Annotation\Service;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Symfony\Component\Form\Extension\Core\Type\CollectionType;
use Symfony\Component\Form\Extension\Core\Type\DateTimeType;
use Symfony\Component\Form\Extension\Core\Type\IntegerType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\Extension\Core\Type\UrlType;
use Symfony\Component\Routing\Router;
use Symfony\Component\Validator\Constraints\Count;
use Symfony\Component\Validator\Constraints\NotBlank;
use Widget\BannerBundle\Model\Banner;
use Widget\BannerBundle\Model\BannerContent;
use Widget\PhotoBundle\Form\Type\PhotoUploadType;
use Widget\PhotoBundle\Model\Photo;

/**
 * @Service()
 */
class BannerContentListener
{
    const CONTROLLER_NAME = 'WidgetBannerBundle:Backend/BannerContent';

    /** @var Router */
    protected $router;

    /**
     * @InjectParams()
     */
    public function injectRouter(Router $router)
    {
        $this->router = $router;
    }

    /**
     * @Observe(MenuEvent::EVENT_MENU)
     */
    public function onMenu(MenuEvent $event)
    {
        $user = $event->getUser();
        if(!$user->hasRoleOrSuperAdmin('ROLE_BANNER_READ')){
            return;
        }

        $isActive = preg_match('/^widget_banner_backend_bannercontent_/i', $event->getRequestRouteName());
        $slug = $user->getSiteSlug();
        $event->addMenu(self::CONTROLLER_NAME, array(
            'menu.banner' => array(
                'class' => 'fa fa-clone',
                'active' => $isActive,
                'target' => array(
                    'menu.banner_list' => array(
                        'class' => 'fa fa-clone',
                        'active' => $isActive,
                        'target' => $this->router->generate('widget_banner_backend_bannercontent_index', array('slug' => $slug)),
                    ),
                ),
            ),
        ));
    }

    /**
     * @Observe(TypeRolesEvent::EVENT_TYPE_ROLES)
     */
    public function onTypeRoles(TypeRolesEvent $event)
    {
        $event->addTypeRoles('ROLE_BANNER', array(
            'ROLE_BANNER_READ',
            'ROLE_BANNER_WRITE',
        ));
    }

    /**
     * @Observe(ConfigEvent::EVENT_CONFIG)
     */
    public function onConfig(ConfigEvent $event)
    {
        if($event->getControllerName() != self::CONTROLLER_NAME){
            return;
        }
        $event->setConfig(array(
            'model' => BannerContent::class,
            'route' => array(
                'sort' => true,
                'index' => true,
                'edit' => true,
                'new' => true,
                'delete' => true,
                'search' => true,
            ),
            'index' => array(
                '#' => 'Id',
                'index.banner.name' => 'Name',
                'index.banner.banner' => 'Banner',
                'index.banner.photos' => '*Photos',
                'index.banner.start_at' => 'StartAt',
                'index.banner.stop_at' => 'StopAt',
                'index.banner.sort' => 'Sort',
                'index.banner.status' => 'Status',
                'index.banner.created_at' => 'CreatedAt',
                'index.banner.updated_at' => 'UpdatedAt',
            ),
            'security' => array(
                'new' => 'ROLE_BANNER_WRITE',
                'edit' => 'ROLE_BANNER_WRITE',
                'delete' =>'ROLE_BANNER_WRITE',
            ),
            'action' => array(
                'action.edit' => array(
                    'class' => 'fa fa-pencil-square-o',
                    'action' => 'edit'
                ),
                'action.delete' => array(
                    'class' => 'fa fa-trash',
                    'action' => 'delete',
                    'confirm' => 'message.confirm.delete',
                ),
            ),
            'search' => array(
                array(
                    'Name',
                    TextType::class,
                    array(
                        'label' => 'index.banner.name',
                        'required' => false,
                    ),
                ),
            ),
            'form' => array(
                //關聯到banner的資料表
                array(
                    'Banner',
                    RelationType::class,
                    array(
                        'label' => 'form.label.edit.banner.banner',
                        'class' => Banner::class,
                        'multiple' => false,
                        'required' => true,
                    ),
                ),
                array(
                    'Name',
                    TextType::class,
                    array(
                        'label' => 'form.label.edit.banner.name',
                        'required' => true,
                    ),
                ),
                array(
                    'Url',
                    UrlType::class,
                    array(
                        'label' => 'form.label.edit.banner.url',
                        'required' => false,
                    ),
                ),
                array(
                    'Target',
                    ChoiceType::class,
                    array(
                        'label' => 'form.label.edit.banner.target.title',
                        'required' => false,
                        'choices' => array(
                            false => 'form.label.edit.banner.target.self',
                            true => 'form.label.edit.banner.target.blank',
                        ),
                        'multiple' => false,
                        'expanded' => true,
                    ),
                ),
                array(
                    'Sort',
                    IntegerType::class,
                    array(
                        'label' => 'form.label.edit.banner.sort',
                        'required' => false,
                    ),
                ),
                array(
                    'StartAt',
                    DateTimeType::class,
                    array(
                        'attr' => array(
                            'data-datetime-range-picker' => true,
                        ),
                        'label' => 'form.label.edit.banner.start_at',
                        'required' => false,
                        'date_widget' => 'single_text',
                        'time_widget' => 'single_text',
                        'with_seconds' => true,
                    ),
                ),
                array(
                    'StopAt',
                    DateTimeType::class,
                    array(
                        'attr' => array(
                            'data-datetime-range-picker' => true,
                        ),
                        'label' => 'form.label.edit.banner.stop_at',
                        'required' => false,
                        'date_widget' => 'single_text',
                        'time_widget' => 'single_text',
                        'with_seconds' => true,
                    ),
                ),
                array(
                    'Status',
                    ChoiceType::class,
                    array(
                        'label' => 'form.label.edit.banner.status',
                        'multiple' => false,
                        'expanded' => true,
                        'choices' => array(
                            true => 'form.choice.enable',
                            false => 'form.choice.disable',
                        ),
                    ),
                ),
                array(
                    'Photos',
                    CollectionType::class,
                    array(
                        'label' => 'form.label.edit.banner.photos',
                        'attr' => array(
                            'data-max-count' => 1,
                        ),
                        'entry_type' => PhotoUploadType::class,
                        'entry_options'  => array(
                            'data_class' => Photo::class,
                            'required' => false,
                        ),
                        'constraints' => array(
                            new NotBlank(array(
                                'message' => 'message.banner.photos.error',
                            )),
                            new Count(array(
                                'max' => 1,
                            )),
                        ),
                        'allow_add' => true,
                        'allow_delete'  => false,
                    ),
                ),
                array(
                    'submit',
                    SubmitBackType::class,
                    array(
                        'with_back' => true,
                        'with_reset' => true,
                        'back_route' => 'widget_banner_backend_bannercontent_index',
                    ),
                ),
            ),
        ));
    }
}