<?php
namespace Widget\BannerBundle\Controller\API;


use Backend\BaseBundle\Controller\API\BaseController;
use Backend\BaseBundle\Model\Site;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Cache;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Method;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\ParamConverter;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Widget\BannerBundle\Model\Banner;
use Widget\BannerBundle\Model\BannerContentQuery;
use Widget\BannerBundle\Model\BannerQuery;

/**
 * @Route("/banner")
 */
class BannerController extends BaseController
{
    /**
     * 取得版位API
     * @Route("/{name}")
     * @Method({"GET"})
     */
    public function getBannerContentAction($name, Site $site)
    {
        if(!($banner = BannerQuery::create()->filterByName($name)->filterBySiteId($site->getId())->findOne())) {
            throw $this->createNotFoundException();
        }

        $query = BannerContentQuery::create()
            ->filterByStatus(true)
            ->orderBySort(\Criteria::DESC)
            ->filterByStartAt(time(), \Criteria::LESS_THAN)
            ->_or()
            ->filterByStartAt(null, \Criteria::ISNULL)
            ->filterByStopAt(time(), \Criteria::GREATER_THAN)
            ->_or()
            ->filterByStopAt(null, \Criteria::ISNULL)
            ;

        $bannerContents = $banner->getBannerContents($query);
        return $this->createJsonSerializeResponse($bannerContents, array('list'));
    }

}