<?php
namespace Widget\ArticleBundle\Tests\Controller\BackendAPI;


use Backend\BaseBundle\Model\SiteUserQuery;
use Backend\BaseBundle\Tests\Fixture\BackendWebTestCase;
use Widget\ArticleBundle\Model\Article;
use Widget\ArticleBundle\Model\ArticleQuery;

class ArticleControllerTest extends BackendWebTestCase
{
    public function test_createAction_success()
    {
        //arrange
        $loginName = 'admin';
        $origin = 'http://localhost';
        $user = SiteUserQuery::create()->findOneByLoginName($loginName);
        $token = $this->createToken($user, $origin);

        $params = array(
            'type' => 'type11111',
            'title' => 'test_title',
            'brief' => 'test_brief',
            'content' => 'test_content'
        );

        //act
        $this->client->request(
            'POST',
            $this->generateUrl('widget_article_backendapi_article_create', array()),
            array(),
            array(),
            array(
                'HTTP_ORIGIN' => $origin,
                'HTTP_AUTHORIZATION' => "Bearer $token",
            ),
            json_encode($params)
        );
        $response = $this->client->getResponse();
        $article = ArticleQuery::create()
            ->findOneByType($params['type']);
        //assert
        $this->assertTrue($response->isOk());
        $this->assertEquals($params['title'], $article->getTitle());
        $this->assertEquals($params['brief'], $article->getBrief());
        $this->assertEquals($params['content'], $article->getContent());

        //reset
        $article->delete();
    }

    public function test_deleteAction()
    {
        //arrange
        $loginName = 'admin';
        $origin = 'http://localhost';
        $user = SiteUserQuery::create()->findOneByLoginName($loginName);
        $token = $this->createToken($user, $origin);

        $article = ArticleQuery::create()->findOneByType('test_delete');

        //act
        $this->client->request(
            'DELETE',
            $this->generateUrl('widget_article_backendapi_article_delete', array('id'=>$article->getId())),
            array(),
            array(),
            array(
                'HTTP_ORIGIN' => $origin,
                'HTTP_AUTHORIZATION' => "Bearer $token",
            )
        );

        $response = $this->client->getResponse();

        //assert
        $this->assertTrue($response->isOk());
        $this->assertNull(ArticleQuery::create()->findOneByType('test_delete'));

        //reset

        $data = $article->toArray();
        $article = new Article();
        $article->fromArray($data);
        $article->save();
    }
}