<?php
namespace Widget\ArticleBundle\Controller\API;

use Backend\BaseBundle\Controller\API\BaseController;
use Backend\BaseBundle\Model\Site;
use Backend\BaseBundle\Propel\I18n;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Cache;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Method;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Widget\ArticleBundle\Model\Article;
use Widget\ArticleBundle\Model\ArticleQuery;

/**
 * @Route("/article")
 */
class ArticleController extends BaseController
{
    /**
     * @Route("/{type}")
     * @Method({"GET"})
     */
    public function getArticleAction(Request $request, Article $article)
    {
        if(!$article){
            return $this->createHttpExceptionResponse(Response::HTTP_NOT_FOUND);
        }

        if($article instanceof I18n){
            $locale = $request->query->get('_locale');
            $article->setLocale($locale);
        }
        
        return $this->createJsonSerializeResponse($article, array('detail'));
    }
}