<?php
namespace Widget\ArticleBundle\EventListener\Serializer;

use JMS\DiExtraBundle\Annotation\Inject;
use JMS\DiExtraBundle\Annotation\InjectParams;
use JMS\DiExtraBundle\Annotation\Service;
use JMS\DiExtraBundle\Annotation\Tag;
use JMS\Serializer\EventDispatcher\PreSerializeEvent;
use Widget\ArticleBundle\Model\Article;
use Widget\PostBundle\Form\Transformer\PostPhotoTransformer;

/**
 * @Service
 * @Tag("jms_serializer.event_listener", attributes = {"public": false, "event": "serializer.pre_serialize", "method": "onArticleSerialize"})
 */
class ArticleSerializerListener
{
    /** @var PostPhotoTransformer  */
    protected $transformer;

    /**
     * @InjectParams({
     *     "transformer" = @Inject("widget_post.post_photo_transformer"),
     * })
     */
    public function injectTransformer(PostPhotoTransformer $transformer)
    {
        $this->transformer = $transformer;
    }

    public function onArticleSerialize(PreSerializeEvent $event)
    {
        $object = $event->getObject();
        if(!($object instanceof Article)){
            return;
        }

        $object->setTransformedContent($this->transformer->transform($object->getContent()));
    }
}