<?php
namespace Widget\ArticleBundle\Controller\API;

use Backend\BaseBundle\Controller\API\BaseController;
use Backend\BaseBundle\Model\Site;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Cache;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Method;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Symfony\Component\HttpFoundation\Response;
use Widget\ArticleBundle\Model\ArticleQuery;

/**
 * @Route("/article")
 */
class ArticleController extends BaseController
{
    /**
     * @Route("/{type}")
     * @Method({"GET"})
     */
    public function getArticleAction($type, Site $site)
    {
        $article = ArticleQuery::create()
            ->filterByType($type)
            ->filterBySiteId($site->getId())
            ->findOne();
        if(!$article){
            return $this->createNotFoundJsonResponse();
        }
        return $this->createJsonSerializeResponse($article, array('detail'));
    }
}