<?php
namespace Widget\ArticleBundle\Tests\Controller\BackendAPI;


use Backend\BaseBundle\Model\SiteConfig;
use Backend\BaseBundle\Model\SiteUserQuery;
use Backend\BaseBundle\Tests\Fixture\BackendWebTestCase;
use Widget\ArticleBundle\Model\Article;
use Widget\ArticleBundle\Model\ArticleI18n;
use Widget\ArticleBundle\Model\ArticleI18nQuery;
use Widget\ArticleBundle\Model\ArticleQuery;

class ArticleControllerTest extends BackendWebTestCase
{
    public function test_createAction_success()
    {
        //arrange
        $loginName = 'admin';
        $origin = 'http://localhost';
        $user = SiteUserQuery::create()->findOneByLoginName($loginName);
        $token = $this->createToken($user, $origin);

        $params = array(
            'type' => 'type11111',
            'title' => 'tileee',
            'brief' => 'brief',
            'content' => 'content',
        );

        //act
        $this->client->request(
            'POST',
            $this->generateUrl('widget_article_backendapi_article_create', array()),
            array(),
            array(),
            array(
                'HTTP_AUTHORIZATION' => "Bearer $token",
                'HTTP_X_Locale' => "zh_TW",
            ),
            json_encode($params)
        );
        $response = $this->client->getResponse();
        $result = json_decode($response->getContent(), true);

        //reset
        $article = ArticleQuery::create()->findOneByType($params['type']);
        $articleI18n = ArticleI18nQuery::create()->filterByArticle($article)->findOneByLocale('zh_TW');
        $article->delete();

        //assert
        $this->assertTrue($response->isOk());
        $this->assertArrayHasKey('id', $result);
        $this->assertArrayHasKey('type', $result);
        $this->assertArrayHasKey('title', $result);
        $this->assertArrayHasKey('brief', $result);
        $this->assertArrayHasKey('content', $result);
        $this->assertArrayHasKey('photos', $result);
        $this->assertArrayHasKey('created_at', $result);
        $this->assertArrayHasKey('updated_at', $result);
        $this->assertEquals($articleI18n->getTitle(), $params['title']);
        $this->assertEquals($articleI18n->getBrief(), $params['brief']);
        $this->assertEquals($articleI18n->getContent(), $params['content']);
    }

    public function test_createAction_zh_CN_success()
    {
        //arrange
        $loginName = 'admin';
        $origin = 'http://localhost';
        $user = SiteUserQuery::create()->findOneByLoginName($loginName);
        $token = $this->createToken($user, $origin);

        $params = array(
            'type' => 'type11111',
            'title' => 'zh_CNtileee',
            'brief' => 'zh_CNbrief',
            'content' => 'zh_CNcontent',
        );

        //act
        $this->client->request(
            'POST',
            $this->generateUrl('widget_article_backendapi_article_create', array()),
            array(),
            array(),
            array(
                'HTTP_AUTHORIZATION' => "Bearer $token",
                'HTTP_X_Locale' => "zh_CN",
            ),
            json_encode($params)
        );
        $response = $this->client->getResponse();
        $result = json_decode($response->getContent(), true);

        //reset
        $article = ArticleQuery::create()->findOneByType($params['type']);
        $articleI18n = ArticleI18nQuery::create()->filterByArticle($article)->findOneByLocale('zh_CN');
        $article->delete();

        //assert
        $this->assertTrue($response->isOk());
        $this->assertArrayHasKey('id', $result);
        $this->assertArrayHasKey('type', $result);
        $this->assertArrayHasKey('title', $result);
        $this->assertArrayHasKey('brief', $result);
        $this->assertArrayHasKey('content', $result);
        $this->assertArrayHasKey('photos', $result);
        $this->assertArrayHasKey('created_at', $result);
        $this->assertArrayHasKey('updated_at', $result);
        $this->assertEquals($articleI18n->getTitle(), $params['title']);
        $this->assertEquals($articleI18n->getBrief(), $params['brief']);
        $this->assertEquals($articleI18n->getContent(), $params['content']);
    }

    public function test_searchAction_success()
    {
        //arrange
        $loginName = 'admin';
        $origin = 'http://localhost';
        $user = SiteUserQuery::create()->findOneByLoginName($loginName);
        $token = $this->createToken($user, $origin);
        $article = new Article();
        $article
            ->setType('type11111')
            ->save();
        $articleI18n = new ArticleI18n();
        $articleI18n
            ->setArticle($article)
            ->setLocale('zh_TW')
            ->setTitle('zh_TWtitle')
            ->setBrief('zh_TWbrief')
            ->setContent('zh_TWcontent')
            ->save();

        //act
        $this->client->request(
            'GET',
            $this->generateUrl('widget_article_backendapi_article_search'),
            array(),
            array(),
            array(
                'HTTP_AUTHORIZATION' => "Bearer $token",
                'HTTP_X_Locale' => "en_US",
            )
        );
        $response = $this->client->getResponse();
        $result = json_decode($response->getContent(), true);

        //reset
        $article->delete();

        //assert
        $this->assertTrue($response->isOk());
        $this->assertArrayHasKey('id', $result['data'][0]);
        $this->assertArrayHasKey('type', $result['data'][0]);
        $this->assertArrayHasKey('title', $result['data'][0]);
        $this->assertArrayHasKey('created_at', $result['data'][0]);
        $this->assertArrayHasKey('updated_at', $result['data'][0]);
        $this->assertEquals($articleI18n->getLocale(), 'zh_TW');
    }

    public function test_readAction_success()
    {
        //arrange
        $loginName = 'admin';
        $origin = 'http://localhost';
        $user = SiteUserQuery::create()->findOneByLoginName($loginName);
        $token = $this->createToken($user, $origin);
        $article = new Article();
        $article
            ->setType('type11111')
            ->save();

        //act
        $this->client->request(
            'GET',
            $this->generateUrl('widget_article_backendapi_article_read', array('id' =>$article->getId())),
            array(),
            array(),
            array(
                'HTTP_AUTHORIZATION' => "Bearer $token",
                'HTTP_X_Locale' => "zh_CN",
            )
        );
        $response = $this->client->getResponse();
        $result = json_decode($response->getContent(), true);

        //reset
        $article->delete();

        //assert
        $this->assertTrue($response->isOk());
        $this->assertArrayHasKey('id', $result);
        $this->assertArrayHasKey('type', $result);
        $this->assertArrayHasKey('title', $result);
        $this->assertArrayHasKey('brief', $result);
        $this->assertArrayHasKey('content', $result);
        $this->assertArrayHasKey('photos', $result);
        $this->assertArrayHasKey('created_at', $result);
        $this->assertArrayHasKey('updated_at', $result);
    }

    public function test_updateAction_success()
    {
        //arrange
        $loginName = 'admin';
        $origin = 'http://localhost';
        $user = SiteUserQuery::create()->findOneByLoginName($loginName);
        $token = $this->createToken($user, $origin);

        $params = array(
            'type' => 'type11111',
            'title' => 'zh_CNtileee',
            'brief' => 'zh_CNbrief',
            'content' => 'zh_CNcontent',
        );
        $article = new Article();
        $article
            ->setType($params['type'])
            ->save();

        //act
        $this->client->request(
            'PUT',
            $this->generateUrl('widget_article_backendapi_article_update', array('id' =>$article->getId())),
            array(),
            array(),
            array(
                'HTTP_AUTHORIZATION' => "Bearer $token",
                'HTTP_X_Locale' => "zh_CN",
            ),
            json_encode($params)
        );
        $response = $this->client->getResponse();
        $result = json_decode($response->getContent(), true);

        //reset
        $articleI18n = ArticleI18nQuery::create()->filterByArticle($article)->findOneByLocale('zh_CN');
        $article->delete();

        //assert
        $this->assertTrue($response->isOk());
        $this->assertArrayHasKey('id', $result);
        $this->assertArrayHasKey('type', $result);
        $this->assertArrayHasKey('title', $result);
        $this->assertArrayHasKey('brief', $result);
        $this->assertArrayHasKey('content', $result);
        $this->assertArrayHasKey('photos', $result);
        $this->assertArrayHasKey('created_at', $result);
        $this->assertArrayHasKey('updated_at', $result);
        $this->assertEquals($articleI18n->getTitle(), $params['title']);
        $this->assertEquals($articleI18n->getBrief(), $params['brief']);
        $this->assertEquals($articleI18n->getContent(), $params['content']);
    }
}