<?php
/**
 * Created by PhpStorm.
 * User: bubble
 * Date: 2018/2/27
 * Time: 下午4:50
 */

namespace Widget\ArticleBundle\Tests\Controller\API;


use Backend\BaseBundle\Tests\Fixture\BaseWebTestCase;
use Symfony\Component\HttpFoundation\Response;
use Widget\ArticleBundle\Model\Article;
use Widget\ArticleBundle\Model\ArticleI18n;

class ArticleControllerTest extends BaseWebTestCase
{
    public function test_getArticleAction_zh_TW()
    {
        //arrange
        $query = array(
            'type' => 'test',
        );
        $article = new Article();
        $article
            ->setType('test')
            ->save();
        $articleI18n = new ArticleI18n();
        $articleI18n
            ->setArticle($article)
            ->setLocale('zh_TW')
            ->setTitle('測試用標題')
            ->setBrief('測試用簡介')
            ->setContent('測試用內容')
            ->save();

        //act
        $this->client->request(
            'GET',
            $this->generateUrl('widget_article_api_article_getarticle', $query),
            array(),
            array(),
            array(
                'HTTP_X_Locale' => "zh_TW",
            )
        );
        $response = $this->client->getResponse();
        $result = json_decode($response->getContent(), true);
        $article->delete();

        //assert
        $this->assertTrue($response->isOk());
        $this->assertArrayHasKey('id', $result);
        $this->assertArrayHasKey('type', $result);
        $this->assertEquals($query['type'], $result['type']);
        $this->assertArrayHasKey('photos', $result);
        $this->assertArrayHasKey('title', $result);
        $this->assertEquals($articleI18n->getTitle(), $result['title']);
        $this->assertArrayHasKey('brief', $result);
        $this->assertEquals($articleI18n->getBrief(), $result['brief']);
        $this->assertArrayHasKey('content', $result);
        $this->assertEquals($articleI18n->getContent(), $result['content']);
        $this->assertArrayHasKey('created_at', $result);
        $this->assertArrayHasKey('updated_at', $result);
    }

    public function test_getArticleAction_zh_CN()
    {
        //arrange
        $query = array(
            'type' => 'test',
        );
        $article = new Article();
        $article
            ->setType('test')
            ->save();
        $articleI18n = new ArticleI18n();
        $articleI18n
            ->setArticle($article)
            ->setLocale('zh_CN')
            ->setTitle('测试用标题')
            ->setBrief('测试用简介')
            ->setContent('测试用内容')
            ->save();

        //act
        $this->client->request(
            'GET',
            $this->generateUrl('widget_article_api_article_getarticle', $query),
            array(),
            array(),
            array(
                'HTTP_X_Locale' => "zh_CN",
            )
        );
        $response = $this->client->getResponse();
        $result = json_decode($response->getContent(), true);
        $article->delete();

        //assert
        $this->assertTrue($response->isOk());
        $this->assertArrayHasKey('id', $result);
        $this->assertArrayHasKey('type', $result);
        $this->assertEquals($query['type'], $result['type']);
        $this->assertArrayHasKey('photos', $result);
        $this->assertArrayHasKey('title', $result);
        $this->assertEquals($articleI18n->getTitle(), $result['title']);
        $this->assertArrayHasKey('brief', $result);
        $this->assertEquals($articleI18n->getBrief(), $result['brief']);
        $this->assertArrayHasKey('content', $result);
        $this->assertEquals($articleI18n->getContent(), $result['content']);
        $this->assertArrayHasKey('created_at', $result);
        $this->assertArrayHasKey('updated_at', $result);
    }

    public function test_getArticleAction_en_US()
    {
        //arrange
        $query = array(
            'type' => 'test',
        );
        $article = new Article();
        $article
            ->setType('test')
            ->save();
        $articleI18n = new ArticleI18n();
        $articleI18n
            ->setArticle($article)
            ->setLocale('en_US')
            ->setTitle('test_title')
            ->setBrief('test_brief')
            ->setContent('test_content')
            ->save();


        //act
        $this->client->request(
            'GET',
            $this->generateUrl('widget_article_api_article_getarticle', $query),
            array(),
            array(),
            array(
                'HTTP_X_Locale' => "en_US",
            )
        );
        $response = $this->client->getResponse();
        $result = json_decode($response->getContent(), true);
        $article->delete();

        //assert
        $this->assertTrue($response->isOk());
        $this->assertArrayHasKey('id', $result);
        $this->assertArrayHasKey('type', $result);
        $this->assertEquals($query['type'], $result['type']);
        $this->assertArrayHasKey('photos', $result);
        $this->assertArrayHasKey('title', $result);
        $this->assertEquals($articleI18n->getTitle(), $result['title']);
        $this->assertArrayHasKey('brief', $result);
        $this->assertEquals($articleI18n->getBrief(), $result['brief']);
        $this->assertArrayHasKey('content', $result);
        $this->assertEquals($articleI18n->getContent(), $result['content']);
        $this->assertArrayHasKey('created_at', $result);
        $this->assertArrayHasKey('updated_at', $result);
    }

    public function test_getArticleAction_dataStatus_is_false()
    {
        //arrange
        $query = array(
            'type' => 'test',
        );
        $article = new Article();
        $article
            ->setType('test')
            ->save();
        $articleI18n = new ArticleI18n();
        $articleI18n
            ->setArticle($article)
            ->setLocale('zh_TW')
            ->setTitle('測試用標題')
            ->setBrief('測試用簡介')
            ->setContent('測試用內容')
            ->setDataStatus(false)
            ->save();

        //act
        $this->client->request(
            'GET',
            $this->generateUrl('widget_article_api_article_getarticle', $query),
            array(),
            array(),
            array(
                'HTTP_X_Locale' => "zh_TW",
            )
        );
        $response = $this->client->getResponse();
        $result = json_decode($response->getContent(), true);
        $article->delete();

        //assert
        $this->assertFalse($response->isOk());
        $this->assertEquals(Response::HTTP_NOT_FOUND, $response->getStatusCode());
    }

    public function test_getArticleAction_no_locale_but_has_default()
    {
        //arrange
        $query = array(
            'type' => 'test',
        );
        $article = new Article();
        $article
            ->setType('test')
            ->save();
        $articleI18n = new ArticleI18n();
        $articleI18n
            ->setArticle($article)
            ->setLocale('zh_TW')
            ->setTitle('測試用標題')
            ->setBrief('測試用簡介')
            ->setContent('測試用內容')
            ->setDataStatus(false)
            ->save();

        //act
        $this->client->request(
            'GET',
            $this->generateUrl('widget_article_api_article_getarticle', $query),
            array(),
            array(),
            array(
//                'HTTP_X_Locale' => "zh_TW",
            )
        );
        $response = $this->client->getResponse();
        $result = json_decode($response->getContent(), true);
        $article->delete();

        //assert
        $this->assertFalse($response->isOk());
        $this->assertEquals(Response::HTTP_NOT_FOUND, $response->getStatusCode());
    }
}