<?php
/**
 * Created by PhpStorm.
 * User: bubble
 * Date: 2018/1/19
 * Time: 下午5:19
 */

namespace Widget\ArticleBundle\Service;


use Symfony\Component\HttpFoundation\Request;
use Widget\ArticleBundle\Model\Article;
use Widget\ArticleBundle\Model\ArticleI18n;
use Widget\ArticleBundle\Model\ArticleQuery;

class ArticleI18nObject
{
    protected $articleI18n;
    protected $_locale;
    protected $_id;
    protected $_type;
    protected $_title;
    protected $_brief;
    protected $_content;
    protected $_photos;
    protected $_data_status;
    protected $_created_at;
    protected $_updated_at;

    public function __construct($parameter, $locale)
    {
        if (!($article = ArticleQuery::create()->findOneByType($parameter['type']))) {
            $article = new Article();
            $article
                ->setType($parameter['type'])
                ->save();
        }
        $this->articleI18n = new ArticleI18n();
        $this->setId($article->getId())
            ->setType($article->getType())
            ->setPhotos($article->getPhotos())
            ->setCreatedAt($article->getCreatedAt())
            ->setUpdatedAt($article->getUpdatedAt());
        $this->setLocale($locale);
        $this->bind($parameter);
    }

    protected function bind($content)
    {
        foreach($content as $key => $value){
            $method = str_replace('_', '', 'set'.ucwords("{$key}", '_'));
            if(is_callable(array($this, $method))) {
                call_user_func(array($this, $method), $value);
            }
        }
    }

    /**
     * @return mixed
     */
    public function getLocale()
    {
        return $this->_locale;
    }

    /**
     * @param $locale
     * @return $this
     */
    public function setLocale($locale)
    {
        $this->_locale = $locale;
        return $this;
    }

    /**
     * @return mixed
     */
    public function getId()
    {
        return $this->_id;
    }

    /**
     * @param $id
     * @return $this
     */
    public function setId($id)
    {
        $this->_id = $id;
        return $this;
    }

    /**
     * @return mixed
     */
    public function getType()
    {
        return $this->_type;
    }

    /**
     * @param $type
     * @return $this
     */
    public function setType($type)
    {
        $this->_type = $type;
        return $this;
    }

    /**
     * @return mixed
     */
    public function getTitle()
    {
        return $this->_title;
    }

    /**
     * @param $title
     * @return $this
     */
    public function setTitle($title)
    {
        $this->_title = $title;
        return $this;
    }

    /**
     * @return mixed
     */
    public function getBrief()
    {
        return $this->_brief;
    }

    /**
     * @param $brief
     * @return $this
     */
    public function setBrief($brief)
    {
        $this->_brief = $brief;
        return $this;
    }

    /**
     * @return mixed
     */
    public function getContent()
    {
        return $this->_content;
    }

    /**
     * @param $content
     * @return $this
     */
    public function setContent($content)
    {
        $this->_content = $content;
        return $this;
    }

    /**
     * @return mixed
     */
    public function getPhotos()
    {
        return $this->_photos;
    }

    /**
     * @param $photos
     * @return $this
     */
    public function setPhotos($photos)
    {
        $this->_photos = $photos;
        return $this;
    }

    /**
     * @return mixed
     */
    public function getDataStatus()
    {
        return $this->_data_status;
    }

    /**
     * @param $dataStatus
     * @return $this
     */
    public function setDataStatus($dataStatus)
    {
        $this->_data_status = $dataStatus;
        return $this;
    }

    /**
     * @return mixed
     */
    public function getCreatedAt()
    {
        return $this->_created_at;
    }

    /**
     * @param $createdAt
     * @return $this
     */
    public function setCreatedAt($createdAt)
    {
        $this->_created_at = $createdAt;
        return $this;
    }

    /**
     * @return mixed
     */
    public function getUpdatedAt()
    {
        return $this->_updated_at;
    }

    /**
     * @param $updatedAt
     * @return $this
     */
    public function setUpdatedAt($updatedAt)
    {
        $this->_updated_at = $updatedAt;
        return $this;
    }

    public function save()
    {
        $this->articleI18n
            ->setId($this->_id)
            ->setLocale($this->_locale)
            ->setTitle($this->_title)
            ->setBrief($this->_brief)
            ->setContent($this->_content)
            ->setDataStatus($this->_data_status)
            ->save();
        return $this->articleI18n;
    }
}