<?php
/**
 * @api {GET} /article/{type}   取得文章
 * @apiName Article
 * @apiGroup Article
 * @apiDescription
 * <ul>
 *   <li>靜態文案建立需照{type}來做區別<br />
 *     文章類型{type}: 前端呼叫API所帶入的值，對應即可帶出相關文案<br />
 *   </li>
 * </ul>
 *
 * @apiUse Locale
 *
 * @apiParam {String} type 文章類型
 *                          <table>
 *                             <tr>
 *                                <th>type</th>
 *                                <th>類型</th>
 *                             </tr>
 *                             <tr>
 *                                <td>private</td>
 *                                <td>隱私權聲明</td>
 *                             </tr>
 *                             <tr>
 *                                <td>policy</td>
 *                                <td>網站條款</td>
 *                             </tr>
 *                          </table>
 *
 * @apiUse HttpNotFoundError
 *
 * @apiSuccess {Object} Article 一般文章
 * @apiSuccess {Integer}  Article.id id
 * @apiSuccess {String}  Article.title 文章標題
 * @apiSuccess {String}  Article.brief 文章簡短內容
 * @apiSuccess {String}  Article.content 文章
 * @apiSuccess {String}  Article.created_at 建立時間 RFC3339 格式
 * @apiSuccess {String}  Article.updated_at 更新時間 RFC3339 格式
 * @apiSuccessExample {JSON} Article 物件範例
 *     HTTP/1.1 200 OK
 *     {
 *          "id":  1234,
 *          "title":   "測試文章",
 *          "type":    "test",
 *          "brief":   "這是測試文章簡介",
 *          "content":   "詳細內容，可畫html樣板放入，可放圖片",
 *          "created_at":  "2017-01-01T00:00:00+08:00",
 *          "updated_at":  "2017-01-01T12:21:45+08:00",
 *     }
 *
 */