<?php
namespace Widget\ArticleBundle\Controller\API;

use Backend\BaseBundle\Controller\API\BaseController;
use Backend\BaseBundle\Model\Site;
use Backend\BaseBundle\Propel\I18n;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Cache;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Method;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Widget\ArticleBundle\Model\Article;
use Widget\ArticleBundle\Model\ArticleQuery;

/**
 * @Route("/article")
 */
class ArticleController extends BaseController
{
    /**
     * @Route("/{type}")
     * @Method({"GET"})
     */
    public function getArticleAction(Request $request, $type)
    {
        $locale = $request->attributes->get('_locale');
        if(!($article = ArticleQuery::create()
            ->joinWithI18n($locale)
            ->useArticleI18nQuery()
                ->filterByDataStatus(true)
            ->endUse()
            ->findOneByType($type))){
            return $this->createHttpExceptionResponse(Response::HTTP_NOT_FOUND);
        }

        $article->setLocale($locale);

        return $this->createJsonSerializeResponse($article, array('f_anonymous_detail'));
    }
}