<?php

namespace Frontend\BaseBundle\Controller;

use Backend\BaseBundle\Service\ServerSideRender;
use JMS\DiExtraBundle\Annotation\Inject;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Cache;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;

class DefaultController extends Controller
{
    /**
     * @var ServerSideRender
     * @Inject()
     */
    protected $serverSideRender;

    /**
     * @Route("/")
     * @Cache(expires="+24 hours", public=true)
     */
    public function indexAction(Request $request)
    {
        try {
            if (($fragment = $request->query->get('_escaped_fragment_')) !== null) {
                $url = "{$request->getSchemeAndHttpHost()}/#!$fragment";
                $result = $this->serverSideRender->render($url);
                if ($result['status']) {
                    return new Response($result['content']);
                }
            }

            $webPath = realpath($this->get('kernel')->getRootDir() . "/../web");
            $content = '';
            if (file_exists("$webPath/index.html")) {
                $content = file_get_contents("$webPath/index.html");
            }
            return new Response($content);
        }
        catch (\Exception $e){
            throw $this->createNotFoundException();
        }
    }

}
