<?php
namespace Backend\BaseBundle\Service;


use Backend\BaseBundle\Model\SiteQuery;
use JMS\DiExtraBundle\Annotation\InjectParams;
use JMS\DiExtraBundle\Annotation\Service;
use Symfony\Component\HttpFoundation\RequestStack;

/**
 *
 * @Service("site.function.checker.enabled", public=false)
 */
class FunctionCheckerServiceEnabled implements FunctionCheckerServiceInterface
{
    protected $site;

    /**
     * @InjectParams()
     */
    public function injectService(RequestStack $requestStack)
    {
        $slug = $requestStack->getMasterRequest()->attributes->get('slug');
        $this->site = SiteQuery::create()->findOneBySlug($slug);
    }

    public function isBundleEnabled($bundleName)
    {
        return in_array($bundleName, $this->site->getEnabledFunctions());
    }

}