<?php
namespace Backend\BaseBundle\Service;

use Symfony\Component\Validator\ConstraintViolationListInterface;
use JMS\DiExtraBundle\Annotation\Service;

/**
 * @Service("api.validator.error.convertor")
 */
class ConstraintViolationListConvertor
{
    public function toArray(ConstraintViolationListInterface $errors)
    {
        $errorMessage = array();
        foreach($errors as $error) {
            $errorMessage[str_replace(array('[', ']'), '', $error->getPropertyPath())] = $error->getMessage();
        }
        return $errorMessage;
    }

    public function toJson(ConstraintViolationListInterface $errors)
    {
        return json_encode($this->toArray($errors));
    }
}