$ () ->
  bindDateTimeRangerPicker = () ->
    $form = $('[data-datetime-range-picker]:first').parents('form')
    $form.submit (e) ->
      $form.find('[data-datetime-range-picker]').each (index, div) ->
        date = $(div).find('input[type="date"]').val()
        time = $(div).find('input[type="time"]').val()
        return if date == ''
        return if time != ''
        $(div).find('input[type="time"]').val '00:00:00'
        return
      return
    return
  toggleSearchField = ($element) ->
    id = $element.attr 'data-search-enabled'
    if $element[0].checked
      $("[id^='#{id}']").prop "disabled", false
      $("[data-search-row='#{id}']").slideDown () ->
        if $('[data-search-row]:visible').length > 0
          $('[data-search-submit]').show()
        return
    else
      $("[id^='#{id}]'").prop "disabled", true
      $("[data-search-row='#{id}']").slideUp () ->
        if $('[data-search-row]:visible').length == 0
          $('[data-search-submit]').hide()
        return
    return
  syncSearchField = () ->
    $('[data-search-enabled]:checked').each (index, element) ->
      toggleSearchField $(element)
      return
    return
  $('body').on 'ifChanged', '[data-search-enabled]', (e) ->
    toggleSearchField $(@)
    return
  $('body').on 'click', '[data-search-row] [data-search-row-hide]', (e) ->
    id = $(@).attr 'data-search-row-hide'
    $("[data-search-enabled='#{id}']").iCheck 'toggle'
    e.preventDefault()
    return
  $('body').on 'click', '[data-search-row-hide]', (e) ->
    # click hide 時順便清掉 input 內容 避免干擾搜尋
    id = $(@).attr 'data-search-row-hide'
    $("[id^='#{id}']").val ''
    e.preventDefault()
    return
  syncSearchField()
  bindDateTimeRangerPicker()
  return