<?php
namespace Backend\BaseBundle\Form\Type;


use JMS\DiExtraBundle\Annotation\Service;
use JMS\DiExtraBundle\Annotation\Tag;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\Form\FormInterface;
use Symfony\Component\Form\FormView;
use Symfony\Component\OptionsResolver\OptionsResolver;

/**
 * @Service
 * @Tag("form.type", attributes = {"alias": "display"})
 */
class DisplayType extends AbstractType
{
    protected $parentType = null;

    public function __construct($parentType = null)
    {
        $this->parentType = $parentType;
    }

    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults(array(
            'template' => null,
        ));
    }

    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder->setAttribute('template', $options['template']);
    }

    public function buildView(FormView $view, FormInterface $form, array $options)
    {
        $view->vars['template'] = $form->getConfig()->getAttribute('template');
    }

    public function getName()
    {
        return 'display';
    }

    public function getParent()
    {
        if($this->parentType !== null){
            return RelationType::class;
        }
        return parent::getParent();
    }

}
