<?php
namespace Backend\BaseBundle\Form\Type;

use Symfony\Component\Form\AbstractType;
use JMS\DiExtraBundle\Annotation\Service;
use JMS\DiExtraBundle\Annotation\Tag;
use Symfony\Component\Form\FormView;
use Symfony\Component\Form\FormInterface;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\Component\Form\Extension\Core\Type as BaseType;

/**
 * @Service
 * @Tag("form.type", attributes = {"alias": "date_range_type"})
 */
class DateRangeType extends AbstractType
{

    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder->add('greater', BaseType\DateType::class, array(
            'label' => 'form.label.type.datetimerange.greater',
            'widget' => 'single_text',
            'required' => false,
        ));
        $builder->add('less', BaseType\DateType::class, array(
            'label' => 'form.label.type.datetimerange.less',
            'widget' => 'single_text',
            'required' => false,
        ));
    }

    public function getName()
    {
        return 'date_range';
    }

}